/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.internal.core.ConsistencyLevelRegistry;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultConsistencyLevelRegistry
implements ConsistencyLevelRegistry {
    private static final ImmutableList<ConsistencyLevel> VALUES = ((ImmutableList.Builder)ImmutableList.builder().add(DefaultConsistencyLevel.values())).build();
    private static final ImmutableMap<String, Integer> NAME_TO_CODE;

    @Override
    public ConsistencyLevel codeToLevel(int code) {
        return DefaultConsistencyLevel.fromCode(code);
    }

    @Override
    public int nameToCode(String name) {
        return NAME_TO_CODE.get(name);
    }

    @Override
    public Iterable<ConsistencyLevel> getValues() {
        return VALUES;
    }

    static {
        ImmutableMap.Builder<String, Integer> nameToCodeBuilder = ImmutableMap.builder();
        for (DefaultConsistencyLevel consistencyLevel : DefaultConsistencyLevel.values()) {
            nameToCodeBuilder.put(consistencyLevel.name(), consistencyLevel.getProtocolCode());
        }
        NAME_TO_CODE = nameToCodeBuilder.build();
    }
}

