/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.adminrequest;

import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.adminrequest.UnexpectedResponseException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Rows;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AdminRequestHandler
implements ResponseCallback {
    private static final Logger LOG = LoggerFactory.getLogger(AdminRequestHandler.class);
    private final DriverChannel channel;
    private final Message message;
    private final Map<String, ByteBuffer> customPayload;
    private final Duration timeout;
    private final String logPrefix;
    private final String debugString;
    protected final CompletableFuture<AdminResult> result = new CompletableFuture();
    private ScheduledFuture<?> timeoutFuture;

    public static AdminRequestHandler query(DriverChannel channel, Query query, Duration timeout, String logPrefix) {
        return AdminRequestHandler.createAdminRequestHandler(channel, query, Collections.emptyMap(), timeout, logPrefix);
    }

    public static AdminRequestHandler query(DriverChannel channel, String query, Map<String, Object> parameters, Duration timeout, int pageSize, String logPrefix) {
        Query message = new Query(query, AdminRequestHandler.buildQueryOptions(pageSize, AdminRequestHandler.serialize(parameters, channel.protocolVersion()), null));
        return AdminRequestHandler.createAdminRequestHandler(channel, message, parameters, timeout, logPrefix);
    }

    private static AdminRequestHandler createAdminRequestHandler(DriverChannel channel, Query message, Map<String, Object> parameters, Duration timeout, String logPrefix) {
        String debugString = "query '" + message.query + "'";
        if (!parameters.isEmpty()) {
            debugString = debugString + " with parameters " + parameters;
        }
        return new AdminRequestHandler(channel, message, Frame.NO_PAYLOAD, timeout, logPrefix, debugString);
    }

    public static AdminRequestHandler query(DriverChannel channel, String query, Duration timeout, int pageSize, String logPrefix) {
        return AdminRequestHandler.query(channel, query, Collections.emptyMap(), timeout, pageSize, logPrefix);
    }

    public AdminRequestHandler(DriverChannel channel, Message message, Map<String, ByteBuffer> customPayload, Duration timeout, String logPrefix, String debugString) {
        this.channel = channel;
        this.message = message;
        this.customPayload = customPayload;
        this.timeout = timeout;
        this.logPrefix = logPrefix;
        this.debugString = debugString;
    }

    public CompletionStage<AdminResult> start() {
        LOG.debug("[{}] Executing {}", (Object)this.logPrefix, (Object)this);
        this.channel.write(this.message, false, this.customPayload, this).addListener(this::onWriteComplete);
        return this.result;
    }

    private void onWriteComplete(Future<? super Void> future) {
        if (future.isSuccess()) {
            LOG.debug("[{}] Successfully wrote {}, waiting for response", (Object)this.logPrefix, (Object)this);
            if (this.timeout.toNanos() > 0L) {
                this.timeoutFuture = this.channel.eventLoop().schedule(this::fireTimeout, this.timeout.toNanos(), TimeUnit.NANOSECONDS);
                this.timeoutFuture.addListener(UncaughtExceptions::log);
            }
        } else {
            this.setFinalError(future.cause());
        }
    }

    private void fireTimeout() {
        this.setFinalError(new DriverTimeoutException(String.format("%s timed out after %s", this.debugString, this.timeout)));
        if (!this.channel.closeFuture().isDone()) {
            this.channel.cancel(this);
        }
    }

    @Override
    public void onFailure(Throwable error) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        this.setFinalError(error);
    }

    @Override
    public void onResponse(Frame responseFrame) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        Message message = responseFrame.message;
        LOG.debug("[{}] Got response {}", (Object)this.logPrefix, (Object)responseFrame.message);
        if (message instanceof Rows) {
            Rows rows = (Rows)message;
            ByteBuffer pagingState = rows.getMetadata().pagingState;
            AdminRequestHandler nextHandler = pagingState == null ? null : this.copy(pagingState);
            this.setFinalResult(new AdminResult(rows, nextHandler, this.channel.protocolVersion()));
        } else if (message instanceof Result) {
            this.setFinalResult(null);
        } else {
            this.setFinalError(new UnexpectedResponseException(this.debugString, message));
        }
    }

    protected boolean setFinalResult(AdminResult result) {
        return this.result.complete(result);
    }

    protected boolean setFinalError(Throwable error) {
        return this.result.completeExceptionally(error);
    }

    private AdminRequestHandler copy(ByteBuffer pagingState) {
        assert (this.message instanceof Query);
        Query current = (Query)this.message;
        QueryOptions currentOptions = current.options;
        QueryOptions newOptions = AdminRequestHandler.buildQueryOptions(currentOptions.pageSize, currentOptions.namedValues, pagingState);
        return new AdminRequestHandler(this.channel, new Query(current.query, newOptions), this.customPayload, this.timeout, this.logPrefix, this.debugString);
    }

    private static QueryOptions buildQueryOptions(int pageSize, Map<String, ByteBuffer> serialize, ByteBuffer pagingState) {
        return new QueryOptions(1, Collections.emptyList(), serialize, false, pageSize, pagingState, 8, Long.MIN_VALUE, null);
    }

    private static Map<String, ByteBuffer> serialize(Map<String, Object> parameters, ProtocolVersion protocolVersion) {
        HashMap<String, ByteBuffer> result = Maps.newHashMapWithExpectedSize(parameters.size());
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            result.put(entry.getKey(), AdminRequestHandler.serialize(entry.getValue(), protocolVersion));
        }
        return result;
    }

    private static ByteBuffer serialize(Object parameter, ProtocolVersion protocolVersion) {
        if (parameter instanceof String) {
            return TypeCodecs.TEXT.encode((String)parameter, protocolVersion);
        }
        if (parameter instanceof InetAddress) {
            return TypeCodecs.INET.encode((InetAddress)parameter, protocolVersion);
        }
        if (parameter instanceof List && ((List)parameter).get(0) instanceof String) {
            List l = (List)parameter;
            return AdminRow.LIST_OF_TEXT.encode(l, protocolVersion);
        }
        throw new IllegalArgumentException("Unsupported variable type for admin query: " + parameter.getClass());
    }

    public String toString() {
        return this.debugString;
    }
}

