/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.InvalidKeyspaceException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.ConnectionInitException;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.channel.ChannelHandlerRequest;
import com.datastax.oss.driver.internal.core.channel.ClusterNameMismatchException;
import com.datastax.oss.driver.internal.core.channel.ConnectInitHandler;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.channel.HeartbeatHandler;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.util.ProtocolUtils;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.AuthResponse;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.Register;
import com.datastax.oss.protocol.internal.request.Startup;
import com.datastax.oss.protocol.internal.response.AuthChallenge;
import com.datastax.oss.protocol.internal.response.AuthSuccess;
import com.datastax.oss.protocol.internal.response.Authenticate;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Ready;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.SetKeyspace;
import io.netty.channel.ChannelHandlerContext;
import java.nio.ByteBuffer;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ProtocolInitHandler
extends ConnectInitHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolInitHandler.class);
    private static final Query CLUSTER_NAME_QUERY = new Query("SELECT cluster_name FROM system.local");
    private final InternalDriverContext context;
    private final long timeoutMillis;
    private final ProtocolVersion initialProtocolVersion;
    private final DriverChannelOptions options;
    private final String expectedClusterName;
    private final EndPoint endPoint;
    private final HeartbeatHandler heartbeatHandler;
    private String logPrefix;
    private ChannelHandlerContext ctx;

    ProtocolInitHandler(InternalDriverContext context, ProtocolVersion protocolVersion, String expectedClusterName, EndPoint endPoint, DriverChannelOptions options, HeartbeatHandler heartbeatHandler) {
        this.context = context;
        this.endPoint = endPoint;
        DriverExecutionProfile defaultConfig = context.getConfig().getDefaultProfile();
        this.timeoutMillis = defaultConfig.getDuration(DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT).toMillis();
        this.initialProtocolVersion = protocolVersion;
        this.expectedClusterName = expectedClusterName;
        this.options = options;
        this.heartbeatHandler = heartbeatHandler;
        this.logPrefix = options.ownerLogPrefix + "|connecting...";
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        String channelId = ctx.channel().toString();
        this.logPrefix = this.options.ownerLogPrefix + "|" + channelId.substring(1, channelId.length() - 1);
    }

    @Override
    protected void onRealConnect(ChannelHandlerContext ctx) {
        LOG.debug("[{}] Starting channel initialization", (Object)this.logPrefix);
        this.ctx = ctx;
        new InitRequest(ctx).send();
    }

    @Override
    protected boolean setConnectSuccess() {
        boolean result = super.setConnectSuccess();
        if (result) {
            this.ctx.pipeline().addBefore("inflight", "heartbeat", this.heartbeatHandler);
        }
        return result;
    }

    private String getString(List<ByteBuffer> row, int i) {
        return TypeCodecs.TEXT.decode(row.get(i), DefaultProtocolVersion.DEFAULT);
    }

    private class InitRequest
    extends ChannelHandlerRequest {
        private Step step;
        private Authenticator authenticator;
        private ByteBuffer authReponseToken;

        InitRequest(ChannelHandlerContext ctx) {
            super(ctx, ProtocolInitHandler.this.timeoutMillis);
            this.step = Step.STARTUP;
        }

        @Override
        String describe() {
            return "[" + ProtocolInitHandler.this.logPrefix + "] init query " + (Object)((Object)this.step);
        }

        @Override
        Message getRequest() {
            switch (this.step) {
                case STARTUP: {
                    return new Startup(ProtocolInitHandler.this.context.getStartupOptions());
                }
                case GET_CLUSTER_NAME: {
                    return CLUSTER_NAME_QUERY;
                }
                case SET_KEYSPACE: {
                    return new Query("USE " + ((ProtocolInitHandler)ProtocolInitHandler.this).options.keyspace.asCql(false));
                }
                case AUTH_RESPONSE: {
                    return new AuthResponse(this.authReponseToken);
                }
                case REGISTER: {
                    return new Register(((ProtocolInitHandler)ProtocolInitHandler.this).options.eventTypes);
                }
            }
            throw new AssertionError((Object)("unhandled step: " + (Object)((Object)this.step)));
        }

        @Override
        void onResponse(Message response) {
            LOG.debug("[{}] step {} received response opcode={}", new Object[]{ProtocolInitHandler.this.logPrefix, this.step, ProtocolUtils.opcodeString(response.opcode)});
            try {
                if (this.step == Step.STARTUP && response instanceof Ready) {
                    ProtocolInitHandler.this.context.getAuthProvider().ifPresent(provider -> provider.onMissingChallenge(ProtocolInitHandler.this.endPoint));
                    this.step = Step.GET_CLUSTER_NAME;
                    this.send();
                } else if (this.step == Step.STARTUP && response instanceof Authenticate) {
                    Authenticate authenticate = (Authenticate)response;
                    this.authenticator = this.buildAuthenticator(ProtocolInitHandler.this.endPoint, authenticate.authenticator);
                    this.authenticator.initialResponse().whenCompleteAsync((token, error) -> {
                        if (error != null) {
                            this.fail(new AuthenticationException(ProtocolInitHandler.this.endPoint, "authenticator threw an exception", (Throwable)error));
                        } else {
                            this.step = Step.AUTH_RESPONSE;
                            this.authReponseToken = token;
                            this.send();
                        }
                    }, this.channel.eventLoop()).exceptionally(UncaughtExceptions::log);
                } else if (this.step == Step.AUTH_RESPONSE && response instanceof AuthChallenge) {
                    ByteBuffer challenge = ((AuthChallenge)response).token;
                    this.authenticator.evaluateChallenge(challenge).whenCompleteAsync((token, error) -> {
                        if (error != null) {
                            this.fail(new AuthenticationException(ProtocolInitHandler.this.endPoint, "authenticator threw an exception", (Throwable)error));
                        } else {
                            this.step = Step.AUTH_RESPONSE;
                            this.authReponseToken = token;
                            this.send();
                        }
                    }, this.channel.eventLoop()).exceptionally(UncaughtExceptions::log);
                } else if (this.step == Step.AUTH_RESPONSE && response instanceof AuthSuccess) {
                    ByteBuffer token2 = ((AuthSuccess)response).token;
                    this.authenticator.onAuthenticationSuccess(token2).whenCompleteAsync((ignored, error) -> {
                        if (error != null) {
                            this.fail(new AuthenticationException(ProtocolInitHandler.this.endPoint, "authenticator threw an exception", (Throwable)error));
                        } else {
                            this.step = Step.GET_CLUSTER_NAME;
                            this.send();
                        }
                    }, this.channel.eventLoop()).exceptionally(UncaughtExceptions::log);
                } else if (this.step == Step.AUTH_RESPONSE && response instanceof Error && ((Error)response).code == 256) {
                    this.fail(new AuthenticationException(ProtocolInitHandler.this.endPoint, String.format("server replied '%s'", ((Error)response).message)));
                } else if (this.step == Step.GET_CLUSTER_NAME && response instanceof Rows) {
                    Rows rows = (Rows)response;
                    List<ByteBuffer> row = rows.getData().poll();
                    String actualClusterName = ProtocolInitHandler.this.getString(row, 0);
                    if (ProtocolInitHandler.this.expectedClusterName != null && !ProtocolInitHandler.this.expectedClusterName.equals(actualClusterName)) {
                        this.fail(new ClusterNameMismatchException(ProtocolInitHandler.this.endPoint, actualClusterName, ProtocolInitHandler.this.expectedClusterName));
                    } else {
                        if (ProtocolInitHandler.this.expectedClusterName == null) {
                            this.channel.attr(DriverChannel.CLUSTER_NAME_KEY).set(actualClusterName);
                        }
                        if (((ProtocolInitHandler)ProtocolInitHandler.this).options.keyspace != null) {
                            this.step = Step.SET_KEYSPACE;
                            this.send();
                        } else if (!((ProtocolInitHandler)ProtocolInitHandler.this).options.eventTypes.isEmpty()) {
                            this.step = Step.REGISTER;
                            this.send();
                        } else {
                            ProtocolInitHandler.this.setConnectSuccess();
                        }
                    }
                } else if (this.step == Step.SET_KEYSPACE && response instanceof SetKeyspace) {
                    if (!((ProtocolInitHandler)ProtocolInitHandler.this).options.eventTypes.isEmpty()) {
                        this.step = Step.REGISTER;
                        this.send();
                    } else {
                        ProtocolInitHandler.this.setConnectSuccess();
                    }
                } else if (this.step == Step.REGISTER && response instanceof Ready) {
                    ProtocolInitHandler.this.setConnectSuccess();
                } else if (response instanceof Error) {
                    Error error2 = (Error)response;
                    if (this.step == Step.STARTUP && (error2.code == 10 || error2.code == 0) && error2.message.contains("Invalid or unsupported protocol version")) {
                        this.fail(UnsupportedProtocolVersionException.forSingleAttempt(ProtocolInitHandler.this.endPoint, ProtocolInitHandler.this.initialProtocolVersion));
                    } else if (this.step == Step.SET_KEYSPACE && error2.code == 8704) {
                        this.fail(new InvalidKeyspaceException(error2.message));
                    } else {
                        this.failOnUnexpected(error2);
                    }
                } else {
                    this.failOnUnexpected(response);
                }
            }
            catch (AuthenticationException e) {
                this.fail(e);
            }
            catch (Throwable t2) {
                this.fail("Unexpected exception at step " + (Object)((Object)this.step), t2);
            }
        }

        @Override
        void fail(String message, Throwable cause) {
            Throwable finalException = message == null ? cause : new ConnectionInitException(message, cause);
            ProtocolInitHandler.this.setConnectFailure(finalException);
        }

        private Authenticator buildAuthenticator(EndPoint endPoint, String authenticator) {
            return ProtocolInitHandler.this.context.getAuthProvider().map(p -> p.newAuthenticator(endPoint, authenticator)).orElseThrow(() -> new AuthenticationException(endPoint, String.format("Node %s requires authentication (%s), but no authenticator configured", endPoint, authenticator)));
        }

        public String toString() {
            return "init query " + (Object)((Object)this.step);
        }
    }

    private static enum Step {
        STARTUP,
        GET_CLUSTER_NAME,
        SET_KEYSPACE,
        AUTH_RESPONSE,
        REGISTER;

    }
}

