/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import java.util.BitSet;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
class StreamIdGenerator {
    private final int maxAvailableIds;
    private final BitSet ids;
    private volatile int availableIds;

    StreamIdGenerator(int maxAvailableIds) {
        this.maxAvailableIds = maxAvailableIds;
        this.ids = new BitSet(this.maxAvailableIds);
        this.availableIds = this.maxAvailableIds;
    }

    int acquire() {
        int id = this.ids.nextClearBit(0);
        if (id >= this.maxAvailableIds) {
            return -1;
        }
        this.ids.set(id);
        --this.availableIds;
        return id;
    }

    void release(int id) {
        if (this.ids.get(id)) {
            ++this.availableIds;
        } else {
            throw new IllegalStateException("Tried to release id that hadn't been borrowed: " + id);
        }
        this.ids.clear(id);
    }

    int getAvailableIds() {
        return this.availableIds;
    }

    int getMaxAvailableIds() {
        return this.maxAvailableIds;
    }
}

