/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class StartupOptionsBuilder {
    public static final String DRIVER_NAME_KEY = "DRIVER_NAME";
    public static final String DRIVER_VERSION_KEY = "DRIVER_VERSION";
    protected final InternalDriverContext context;

    public StartupOptionsBuilder(InternalDriverContext context) {
        this.context = context;
    }

    public Map<String, String> build() {
        NullAllowingImmutableMap.Builder<String, String> builder = NullAllowingImmutableMap.builder(3);
        String compressionAlgorithm = this.context.getCompressor().algorithm();
        if (compressionAlgorithm != null && !compressionAlgorithm.trim().isEmpty()) {
            builder.put("COMPRESSION", compressionAlgorithm.trim());
        }
        return builder.put(DRIVER_NAME_KEY, this.getDriverName()).put(DRIVER_VERSION_KEY, this.getDriverVersion()).build();
    }

    protected String getDriverName() {
        return Session.OSS_DRIVER_COORDINATES.getName();
    }

    protected String getDriverVersion() {
        return Session.OSS_DRIVER_COORDINATES.getVersion().toString();
    }
}

