/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.util.ArrayUtils;
import com.datastax.oss.driver.internal.core.util.Reflection;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultLoadBalancingPolicy
implements LoadBalancingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLoadBalancingPolicy.class);
    private static final Predicate<Node> INCLUDE_ALL_NODES = n -> true;
    private static final IntUnaryOperator INCREMENT = i -> i == Integer.MAX_VALUE ? 0 : i + 1;
    private final String logPrefix;
    private final MetadataManager metadataManager;
    private final Predicate<Node> filter;
    private final AtomicInteger roundRobinAmount = new AtomicInteger();
    private final boolean isDefaultPolicy;
    @VisibleForTesting
    final CopyOnWriteArraySet<Node> localDcLiveNodes = new CopyOnWriteArraySet();
    private volatile LoadBalancingPolicy.DistanceReporter distanceReporter;
    @VisibleForTesting
    volatile String localDc;

    public DefaultLoadBalancingPolicy(@NonNull DriverContext context, @NonNull String profileName) {
        InternalDriverContext internalContext = (InternalDriverContext)context;
        this.logPrefix = context.getSessionName() + "|" + profileName;
        DriverExecutionProfile config = context.getConfig().getProfile(profileName);
        this.localDc = this.getLocalDcFromConfig(internalContext, profileName, config);
        this.isDefaultPolicy = profileName.equals("default");
        this.metadataManager = internalContext.getMetadataManager();
        Predicate<Node> filterFromConfig = this.getFilterFromConfig(internalContext, profileName);
        this.filter = node -> {
            String localDc1 = this.localDc;
            if (localDc1 != null && !localDc1.equals(node.getDatacenter())) {
                LOG.debug("[{}] Ignoring {} because it doesn't belong to the local DC {}", this.logPrefix, node, localDc1);
                return false;
            }
            if (!filterFromConfig.test((Node)node)) {
                LOG.debug("[{}] Ignoring {} because it doesn't match the user-provided predicate", (Object)this.logPrefix, node);
                return false;
            }
            return true;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(@NonNull Map<UUID, Node> nodes, @NonNull LoadBalancingPolicy.DistanceReporter distanceReporter) {
        this.distanceReporter = distanceReporter;
        Set<DefaultNode> contactPoints = this.metadataManager.getContactPoints();
        if (this.localDc == null) {
            if (!this.metadataManager.wasImplicitContactPoint()) throw new IllegalStateException("You provided explicit contact points, the local DC must be specified (see " + DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER.getPath() + " in the config)");
            assert (contactPoints.size() == 1);
            Node contactPoint = contactPoints.iterator().next();
            this.localDc = contactPoint.getDatacenter();
            LOG.debug("[{}] Local DC set from contact point {}: {}", this.logPrefix, contactPoint, this.localDc);
        } else {
            ImmutableMap.Builder<Node, String> builder = ImmutableMap.builder();
            for (Node node : contactPoints) {
                String datacenter = node.getDatacenter();
                if (Objects.equals(this.localDc, datacenter)) continue;
                builder.put(node, datacenter == null ? "<null>" : datacenter);
            }
            ImmutableMap badContactPoints = builder.build();
            if (this.isDefaultPolicy && !badContactPoints.isEmpty()) {
                LOG.warn("[{}] You specified {} as the local DC, but some contact points are from a different DC ({})", this.logPrefix, this.localDc, badContactPoints);
            }
        }
        for (Node node : nodes.values()) {
            if (this.filter.test(node)) {
                distanceReporter.setDistance(node, NodeDistance.LOCAL);
                if (node.getState() == NodeState.DOWN) continue;
                this.localDcLiveNodes.add(node);
                continue;
            }
            distanceReporter.setDistance(node, NodeDistance.IGNORED);
        }
    }

    @Override
    @NonNull
    public Queue<Node> newQueryPlan(@Nullable Request request, @Nullable Session session) {
        Object[] currentNodes = this.localDcLiveNodes.toArray();
        Set<Node> allReplicas = this.getReplicas(request, session);
        int replicaCount = 0;
        if (!allReplicas.isEmpty()) {
            for (int i = 0; i < currentNodes.length; ++i) {
                Node node = (Node)currentNodes[i];
                if (!allReplicas.contains(node)) continue;
                ArrayUtils.bubbleUp(currentNodes, i, replicaCount);
                ++replicaCount;
            }
            if (replicaCount > 1) {
                this.shuffleHead(currentNodes, replicaCount);
            }
        }
        LOG.trace("[{}] Prioritizing {} local replicas", (Object)this.logPrefix, (Object)replicaCount);
        ArrayUtils.rotate(currentNodes, replicaCount, currentNodes.length - replicaCount, this.roundRobinAmount.getAndUpdate(INCREMENT));
        return new QueryPlan(currentNodes);
    }

    private Set<Node> getReplicas(Request request, Session session) {
        ByteBuffer key;
        if (request == null || session == null) {
            return Collections.emptySet();
        }
        CqlIdentifier keyspace = request.getKeyspace();
        if (keyspace == null) {
            keyspace = request.getRoutingKeyspace();
        }
        if (keyspace == null && session.getKeyspace().isPresent()) {
            keyspace = session.getKeyspace().get();
        }
        if (keyspace == null) {
            return Collections.emptySet();
        }
        Token token = request.getRoutingToken();
        ByteBuffer byteBuffer = key = token == null ? request.getRoutingKey() : null;
        if (token == null && key == null) {
            return Collections.emptySet();
        }
        Optional<TokenMap> maybeTokenMap = this.metadataManager.getMetadata().getTokenMap();
        if (maybeTokenMap.isPresent()) {
            TokenMap tokenMap = maybeTokenMap.get();
            return token != null ? tokenMap.getReplicas(keyspace, token) : tokenMap.getReplicas(keyspace, key);
        }
        return Collections.emptySet();
    }

    @VisibleForTesting
    protected void shuffleHead(Object[] currentNodes, int replicaCount) {
        ArrayUtils.shuffleHead(currentNodes, replicaCount);
    }

    @Override
    public void onAdd(@NonNull Node node) {
        if (this.filter.test(node)) {
            LOG.debug("[{}] {} was added, setting distance to LOCAL", (Object)this.logPrefix, (Object)node);
            this.distanceReporter.setDistance(node, NodeDistance.LOCAL);
        } else {
            this.distanceReporter.setDistance(node, NodeDistance.IGNORED);
        }
    }

    @Override
    public void onUp(@NonNull Node node) {
        if (this.filter.test(node)) {
            this.distanceReporter.setDistance(node, NodeDistance.LOCAL);
            if (this.localDcLiveNodes.add(node)) {
                LOG.debug("[{}] {} came back UP, added to live set", (Object)this.logPrefix, (Object)node);
            }
        } else {
            this.distanceReporter.setDistance(node, NodeDistance.IGNORED);
        }
    }

    @Override
    public void onDown(@NonNull Node node) {
        if (this.localDcLiveNodes.remove(node)) {
            LOG.debug("[{}] {} went DOWN, removed from live set", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void onRemove(@NonNull Node node) {
        if (this.localDcLiveNodes.remove(node)) {
            LOG.debug("[{}] {} was removed, removed from live set", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void close() {
    }

    private String getLocalDcFromConfig(InternalDriverContext internalContext, @NonNull String profileName, DriverExecutionProfile config) {
        String localDc = internalContext.getLocalDatacenter(profileName);
        if (localDc != null) {
            LOG.debug("[{}] Local DC set from builder: {}", (Object)this.logPrefix, (Object)localDc);
        } else {
            localDc = config.getString(DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, null);
            if (localDc != null) {
                LOG.debug("[{}] Local DC set from configuration: {}", (Object)this.logPrefix, (Object)localDc);
            }
        }
        return localDc;
    }

    private Predicate<Node> getFilterFromConfig(InternalDriverContext context, String profileName) {
        Predicate<Node> filterFromBuilder = context.getNodeFilter(profileName);
        return filterFromBuilder != null ? filterFromBuilder : Reflection.buildFromConfig(context, profileName, DefaultDriverOption.LOAD_BALANCING_FILTER_CLASS, Predicate.class, new String[0]).orElse(INCLUDE_ALL_NODES);
    }
}

