/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultFunctionMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class FunctionParser {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionParser.class);
    private final DataTypeParser dataTypeParser;
    private final InternalDriverContext context;
    private final String logPrefix;

    public FunctionParser(DataTypeParser dataTypeParser, InternalDriverContext context) {
        this.dataTypeParser = dataTypeParser;
        this.context = context;
        this.logPrefix = context.getSessionName();
    }

    public FunctionMetadata parseFunction(AdminRow row, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userDefinedTypes) {
        String simpleName = row.getString("function_name");
        ImmutableList<CqlIdentifier> argumentNames = ImmutableList.copyOf(Lists.transform(row.getListOfString("argument_names"), CqlIdentifier::fromInternal));
        List<String> argumentTypes = row.getListOfString("argument_types");
        if (argumentNames.size() != argumentTypes.size()) {
            LOG.warn("[{}] Error parsing system row for function {}.{}, number of argument names and types don't match (got {} and {}).", this.logPrefix, keyspaceId.asInternal(), simpleName, argumentNames.size(), argumentTypes.size());
            return null;
        }
        FunctionSignature signature = new FunctionSignature(CqlIdentifier.fromInternal(simpleName), this.dataTypeParser.parse(keyspaceId, argumentTypes, userDefinedTypes, this.context));
        String body = row.getString("body");
        Boolean calledOnNullInput = row.getBoolean("called_on_null_input");
        String language = row.getString("language");
        DataType returnType = this.dataTypeParser.parse(keyspaceId, row.getString("return_type"), userDefinedTypes, this.context);
        return new DefaultFunctionMetadata(keyspaceId, signature, argumentNames, body, calledOnNullInput, language, returnType);
    }
}

