/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.metrics.HdrReservoir;
import com.datastax.oss.driver.internal.core.metrics.MetricUpdater;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class DropwizardMetricUpdater<MetricT>
implements MetricUpdater<MetricT> {
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardMetricUpdater.class);
    protected final Set<MetricT> enabledMetrics;
    protected final MetricRegistry registry;

    protected DropwizardMetricUpdater(Set<MetricT> enabledMetrics, MetricRegistry registry) {
        this.enabledMetrics = enabledMetrics;
        this.registry = registry;
    }

    protected abstract String buildFullName(MetricT var1, String var2);

    @Override
    public void incrementCounter(MetricT metric, String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.counter(this.buildFullName(metric, profileName)).inc(amount);
        }
    }

    @Override
    public void updateHistogram(MetricT metric, String profileName, long value) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.histogram(this.buildFullName(metric, profileName)).update(value);
        }
    }

    @Override
    public void markMeter(MetricT metric, String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.meter(this.buildFullName(metric, profileName)).mark(amount);
        }
    }

    @Override
    public void updateTimer(MetricT metric, String profileName, long duration, TimeUnit unit) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.timer(this.buildFullName(metric, profileName)).update(duration, unit);
        }
    }

    public <T extends Metric> T getMetric(MetricT metric, String profileName) {
        return (T)this.registry.getMetrics().get(this.buildFullName(metric, profileName));
    }

    @Override
    public boolean isEnabled(MetricT metric, String profileName) {
        return this.enabledMetrics.contains(metric);
    }

    protected void initializeDefaultCounter(MetricT metric, String profileName) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.counter(this.buildFullName(metric, profileName));
        }
    }

    protected void initializeHdrTimer(MetricT metric, DriverExecutionProfile config, DriverOption highestLatencyOption, DriverOption significantDigitsOption, DriverOption intervalOption) {
        String profileName = config.getName();
        if (this.isEnabled(metric, profileName)) {
            int significantDigits;
            String fullName = this.buildFullName(metric, profileName);
            Duration highestLatency = config.getDuration(highestLatencyOption);
            int d = config.getInt(significantDigitsOption);
            if (d >= 0 && d <= 5) {
                significantDigits = d;
            } else {
                LOG.warn("[{}] Configuration option {} is out of range (expected between 0 and 5, found {}); using 3 instead.", fullName, significantDigitsOption, d);
                significantDigits = 3;
            }
            Duration refreshInterval = config.getDuration(intervalOption);
            this.registry.timer(fullName, () -> new Timer(new HdrReservoir(highestLatency, significantDigits, refreshInterval, fullName)));
        }
    }
}

