/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.protocol.internal.Compressor;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class ByteBufCompressor
implements Compressor<ByteBuf> {
    @Override
    public ByteBuf compress(ByteBuf uncompressed) {
        return uncompressed.isDirect() ? this.compressDirect(uncompressed) : this.compressHeap(uncompressed);
    }

    protected abstract ByteBuf compressDirect(ByteBuf var1);

    protected abstract ByteBuf compressHeap(ByteBuf var1);

    @Override
    public ByteBuf decompress(ByteBuf compressed) {
        return compressed.isDirect() ? this.decompressDirect(compressed) : this.decompressHeap(compressed);
    }

    protected abstract ByteBuf decompressDirect(ByteBuf var1);

    protected abstract ByteBuf decompressHeap(ByteBuf var1);

    protected static ByteBuffer inputNioBuffer(ByteBuf buf) {
        int index = buf.readerIndex();
        int len = buf.readableBytes();
        return buf.nioBufferCount() == 1 ? buf.internalNioBuffer(index, len) : buf.nioBuffer(index, len);
    }

    protected static ByteBuffer outputNioBuffer(ByteBuf buf) {
        int index = buf.writerIndex();
        int len = buf.writableBytes();
        return buf.nioBufferCount() == 1 ? buf.internalNioBuffer(index, len) : buf.nioBuffer(index, len);
    }
}

