/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.channels.multi;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.channels.multi.ProtoConnections;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.channel.ChannelListener;
import pt.unl.fct.di.novasys.channel.base.SingleThreadedBiChannel;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.listeners.InConnListener;

public class MultiChannel
extends SingleThreadedBiChannel<BabelMessage, BabelMessage>
implements AttributeValidator {
    private static final Logger logger = LogManager.getLogger(MultiChannel.class);
    private static final short TCP_MAGIC_NUMBER = 10023;
    protected static final String LISTEN_ADDRESS_ATTRIBUTE = "listen_address";
    private static final int DEFAULT_PORT = 12727;
    private final NetworkManager<BabelMessage> network;
    private final Map<Short, ChannelListener<BabelMessage>> listeners = new HashMap<Short, ChannelListener<BabelMessage>>();
    private Attributes attributes;
    private Map<Integer, ProtoConnections> protocolConnections = new HashMap<Integer, ProtoConnections>();
    private static MultiChannel multiChannelInstance = null;

    public static MultiChannel getInstance(ISerializer<BabelMessage> serializer, ChannelListener<BabelMessage> list, short protoId, Properties properties) throws IOException {
        if (multiChannelInstance == null) {
            multiChannelInstance = new MultiChannel(serializer, properties);
        }
        multiChannelInstance.addListener(protoId, list);
        return multiChannelInstance;
    }

    private void addListener(short protoId, ChannelListener<BabelMessage> list) {
        if (this.listeners.putIfAbsent(protoId, list) != null) {
            throw new RuntimeException("Protocol with id " + protoId + " asked for Multi Channel twice");
        }
    }

    private MultiChannel(ISerializer<BabelMessage> serializer, Properties properties) throws IOException {
        super("MultiChannel");
        InetAddress addr = null;
        if (properties.containsKey("address")) {
            addr = Inet4Address.getByName(properties.getProperty("address"));
        }
        if (addr == null) {
            throw new AssertionError((Object)"No address received in Multi Channel properties");
        }
        int port = 12727;
        if (properties.containsKey("port")) {
            port = Integer.parseInt(properties.getProperty("port"));
        }
        this.network = new NetworkManager<BabelMessage>(serializer, this, 1000, 3000, 1000);
        int nThreads = Integer.parseInt(properties.getProperty("nThreads", "0"));
        Host listenAddress = new Host(addr, port);
        this.network.createServerSocket((InConnListener<BabelMessage>)this, listenAddress, (AttributeValidator)this, nThreads);
        this.attributes = new Attributes();
        this.attributes.putShort("magic_number", (short)10023);
        this.attributes.putHost(LISTEN_ADDRESS_ATTRIBUTE, listenAddress);
    }

    @Override
    protected void onInboundConnectionUp(Connection<BabelMessage> connection) {
        short protoId;
        Host clientSocket;
        try {
            clientSocket = connection.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTRIBUTE);
            protoId = connection.getPeerAttributes().getShort("Protocol_ID");
        }
        catch (IOException e) {
            logger.error("Inbound connection without valid listen address: " + e.getMessage());
            connection.disconnect();
            return;
        }
        logger.debug("Inbound up: " + String.valueOf(connection) + " " + String.valueOf(clientSocket));
        this.protocolConnections.computeIfAbsent(Integer.valueOf(protoId), k -> new ProtoConnections(this.loop, protoId, this.attributes, this.listeners.get(protoId), this.network, this)).addInboundConnection(clientSocket, connection);
    }

    @Override
    protected void onInboundConnectionDown(Connection<BabelMessage> connection, Throwable cause) {
        short protoId = connection.getPeerAttributes().getShort("Protocol_ID");
        ProtoConnections protoConnections = this.protocolConnections.get(protoId);
        if (protoConnections != null) {
            protoConnections.removeInboundConnection(connection, cause);
        }
    }

    @Override
    protected void onServerSocketBind(boolean success, Throwable cause) {
        if (success) {
            logger.debug("Server socket ready");
        } else {
            logger.error("Server socket bind failed: " + String.valueOf(cause));
        }
    }

    @Override
    protected void onServerSocketClose(boolean success, Throwable cause) {
        logger.debug("Server socket closed. " + (String)(success ? "" : "Cause: " + String.valueOf(cause)));
    }

    @Override
    protected void onOutboundConnectionUp(Connection<BabelMessage> connection) {
        short protoId = connection.getSelfAttributes().getShort("Protocol_ID");
        this.protocolConnections.computeIfAbsent(Integer.valueOf(protoId), k -> new ProtoConnections(this.loop, protoId, this.attributes, this.listeners.get(protoId), this.network, this)).addOutboundConnection(connection);
    }

    @Override
    protected void onOutboundConnectionDown(Connection<BabelMessage> connection, Throwable cause) {
        short protoId = connection.getSelfAttributes().getShort("Protocol_ID");
        ProtoConnections protoConnections = this.protocolConnections.get(protoId);
        if (protoConnections != null) {
            protoConnections.removeOutboundConnection(connection, cause);
        }
    }

    @Override
    protected void onOutboundConnectionFailed(Connection<BabelMessage> connection, Throwable cause) {
        short protoId = connection.getSelfAttributes().getShort("Protocol_ID");
        ProtoConnections protoConnections = this.protocolConnections.get(protoId);
        if (protoConnections != null) {
            protoConnections.failedOutboundConnection(connection, cause);
        }
    }

    @Override
    protected void onSendMessage(BabelMessage protoMessage, Host host, int mode) {
        this.protocolConnections.computeIfAbsent(Integer.valueOf(protoMessage.getDestProto()), k -> new ProtoConnections(this.loop, protoMessage.getDestProto(), this.attributes, this.listeners.get(protoMessage.getDestProto()), this.network, this)).sendMessage(protoMessage, host, mode);
    }

    @Override
    protected void onCloseConnection(Host host, int connection) {
        ProtoConnections protoConnections = this.protocolConnections.get(connection);
        if (protoConnections != null) {
            protoConnections.disconnect(host);
        }
    }

    @Override
    protected void onDeliverMessage(BabelMessage protoMessage, Connection<BabelMessage> connection) {
        ProtoConnections protoConnections = this.protocolConnections.get(protoMessage.getSourceProto());
        if (protoConnections != null) {
            protoConnections.deliverMessage(protoMessage, connection);
        }
    }

    @Override
    protected void onOpenConnection(Host host, int connection) {
        throw new NotImplementedException("Pls fix me");
    }

    @Override
    public boolean validateAttributes(Attributes attributes) {
        Short channel = attributes.getShort("magic_number");
        return channel != null && channel == 10023;
    }
}

