/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.AutoConfigureParameter;
import pt.unl.fct.di.novasys.babel.core.BabelMessageSerializer;
import pt.unl.fct.di.novasys.babel.core.ChannelToProtoForwarder;
import pt.unl.fct.di.novasys.babel.core.DiscoverableProtocol;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.core.SelfConfigurableProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.DiscoveryProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.requests.RequestDiscovery;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.SelfConfigurationProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.exceptions.InvalidParameterException;
import pt.unl.fct.di.novasys.babel.exceptions.NoSuchProtocolException;
import pt.unl.fct.di.novasys.babel.exceptions.ProtocolAlreadyExistsException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.generic.ProtoTimer;
import pt.unl.fct.di.novasys.babel.initializers.AccrualChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.ChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.SharedTCPChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.SimpleClientChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.SimpleServerChannelInitializer;
import pt.unl.fct.di.novasys.babel.initializers.TCPChannelInitializer;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.babel.internal.IPCEvent;
import pt.unl.fct.di.novasys.babel.internal.NotificationEvent;
import pt.unl.fct.di.novasys.babel.internal.TimerEvent;
import pt.unl.fct.di.novasys.babel.metrics.MetricsManager;
import pt.unl.fct.di.novasys.channel.IChannel;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class Babel {
    private static final Logger logger = LogManager.getLogger(Babel.class);
    private static Babel system;
    private static Properties props;
    private final Map<Short, GenericProtocol> protocolMap = new ConcurrentHashMap<Short, GenericProtocol>();
    private final Map<String, GenericProtocol> protocolByNameMap = new ConcurrentHashMap<String, GenericProtocol>();
    private final Map<Short, Set<GenericProtocol>> subscribers = new ConcurrentHashMap<Short, Set<GenericProtocol>>();
    public static final String PAR_DEFAULT_INTERFACE = "babel.interface";
    public static final String PAR_DEFAULT_ADDRESS = "babel.address";
    public static final String PAR_DEFAULT_PORT = "babel.port";
    public static final String PAR_DISCOVERY_PROTOCOL = "babel.discovery";
    public static final String PAR_SELF_CONFIGURATION_PROTOCOL = "babel.selfconfiguration";
    private final List<DiscoveryProtocol> discoveries = new ArrayList<DiscoveryProtocol>();
    private SelfConfigurationProtocol selfConfiguration;
    private final Map<Long, TimerEvent> allTimers = new HashMap<Long, TimerEvent>();
    private final PriorityBlockingQueue<TimerEvent> timerQueue = new PriorityBlockingQueue();
    private final Thread timersThread;
    public final AtomicLong timersCounter = new AtomicLong();
    private final Map<String, ChannelInitializer<? extends IChannel<BabelMessage>>> initializers;
    private final Map<Integer, Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer>> channelMap;
    private final AtomicInteger channelIdGenerator;
    private long startTime;
    private boolean started = false;

    public static synchronized Babel getInstance() {
        if (system == null) {
            system = new Babel();
        }
        return system;
    }

    private Babel() {
        this.timersThread = new Thread(this::timerLoop);
        this.channelMap = new ConcurrentHashMap<Integer, Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer>>();
        this.channelIdGenerator = new AtomicInteger(0);
        this.initializers = new ConcurrentHashMap<String, ChannelInitializer<? extends IChannel<BabelMessage>>>();
        this.registerChannelInitializer("ClientChannel", new SimpleClientChannelInitializer());
        this.registerChannelInitializer("ServerChannel", new SimpleServerChannelInitializer());
        this.registerChannelInitializer("TCPChannel", new TCPChannelInitializer());
        this.registerChannelInitializer("AccrualChannel", new AccrualChannelInitializer());
        this.registerChannelInitializer("SharedTCPChannel", new SharedTCPChannelInitializer());
    }

    private void timerLoop() {
        while (true) {
            long toSleep;
            long now = this.getMillisSinceStart();
            TimerEvent tE = this.timerQueue.peek();
            long l = toSleep = tE != null ? tE.getTriggerTime() - now : Long.MAX_VALUE;
            if (toSleep <= 0L) {
                TimerEvent t2 = (TimerEvent)this.timerQueue.remove();
                t2.getConsumer().deliverTimer(t2);
                if (!t2.isPeriodic()) continue;
                t2.setTriggerTime(now + t2.getPeriod());
                this.timerQueue.add(t2);
                continue;
            }
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void setupDiscoverable(DiscoverableProtocol dcProto) {
        this.discoveries.forEach(discovery -> discovery.registerProtocol(dcProto));
    }

    public void setupSelfConfiguration(SelfConfigurableProtocol scProto) {
        Field[] fields;
        Class<?> scProtoClass = scProto.getClass();
        for (Field field : fields = scProtoClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(AutoConfigureParameter.class)) continue;
            String fieldNameCapitalized = StringUtils.capitalize(field.getName());
            String getterName = "getFirst" + fieldNameCapitalized;
            String setterName = "setFirst" + fieldNameCapitalized;
            try {
                Method getter = scProtoClass.getMethod(getterName, new Class[0]);
                Method setter = scProtoClass.getMethod(setterName, String.class);
                if (getter.invoke((Object)scProto, new Object[0]) == null) {
                    this.selfConfiguration.addProtocolParameterToConfigure(field.getName(), setter, getter, scProto);
                    continue;
                }
                this.selfConfiguration.addProtocolParameterConfigured(field.getName(), setter, getter, scProto);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void askRunningDiscovery(GenericProtocol proto, Host myself, boolean listen) {
        for (DiscoveryProtocol discovery : this.discoveries) {
            proto.sendRequest(new RequestDiscovery(proto.getProtoName(), myself, proto.getProtoName(), listen), discovery.getProtoId());
        }
    }

    public void start() {
        if (props.containsKey(PAR_DISCOVERY_PROTOCOL)) {
            try {
                String[] discoveryClassNames;
                logger.debug("Attempting to load Discovery Protocol: " + props.getProperty(PAR_DISCOVERY_PROTOCOL));
                for (String className : discoveryClassNames = props.getProperty(PAR_DISCOVERY_PROTOCOL).split(";")) {
                    Class<?> discoveryClass = Class.forName(className);
                    this.discoveries.add((DiscoveryProtocol)discoveryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to load DiscoveryProtocol: '" + props.getProperty(PAR_DISCOVERY_PROTOCOL) + "'");
            }
        } else {
            logger.debug("No Discovery Protocol was requested to be loaded.");
        }
        if (props.containsKey(PAR_SELF_CONFIGURATION_PROTOCOL)) {
            try {
                logger.debug("Attemptimg to load Self Configuration Protocl: " + props.getProperty(PAR_SELF_CONFIGURATION_PROTOCOL));
                Class<?> selfConfigurationClass = Class.forName(props.getProperty(PAR_SELF_CONFIGURATION_PROTOCOL));
                this.selfConfiguration = (SelfConfigurationProtocol)selfConfigurationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to load SelfConfigurationProtocol: '" + props.getProperty(PAR_SELF_CONFIGURATION_PROTOCOL) + "'");
            }
        } else {
            logger.debug("No Self Configuration Protocol was requested to be loaded");
            this.selfConfiguration = null;
        }
        try {
            for (DiscoveryProtocol discovery : this.discoveries) {
                this.registerProtocol(discovery);
            }
            if (this.selfConfiguration != null) {
                this.registerProtocol(this.selfConfiguration);
            }
        }
        catch (ProtocolAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        this.startTime = System.currentTimeMillis();
        this.started = true;
        try {
            for (DiscoveryProtocol discovery : this.discoveries) {
                discovery.init(props);
            }
            if (this.selfConfiguration != null) {
                this.selfConfiguration.init(props);
            }
        }
        catch (IOException | HandlerRegistrationException e) {
            throw new RuntimeException(e);
        }
        MetricsManager.getInstance().start();
        this.timersThread.start();
        for (GenericProtocol proto : this.protocolMap.values()) {
            DiscoverableProtocol dcProto;
            logger.info("Starting " + proto.getProtoName());
            if (this.discoveries.size() != 0 && proto instanceof DiscoverableProtocol) {
                dcProto = (DiscoverableProtocol)proto;
                this.setupDiscoverable(dcProto);
            }
            if (this.selfConfiguration != null && proto instanceof SelfConfigurableProtocol) {
                SelfConfigurableProtocol scProto = (SelfConfigurableProtocol)proto;
                this.setupSelfConfiguration(scProto);
            }
            if (proto instanceof DiscoverableProtocol) {
                dcProto = (DiscoverableProtocol)proto;
                if (!dcProto.readyToStart()) continue;
                dcProto.start();
                dcProto.startEventThread();
                continue;
            }
            proto.startEventThread();
        }
        if (this.selfConfiguration != null) {
            this.askRunningDiscovery(this.selfConfiguration, this.selfConfiguration.getMyself(), true);
        }
    }

    public void registerProtocol(GenericProtocol p) throws ProtocolAlreadyExistsException {
        GenericProtocol old = this.protocolMap.putIfAbsent(p.getProtoId(), p);
        if (old != null) {
            throw new ProtocolAlreadyExistsException("Protocol conflicts on id with protocol: id=" + p.getProtoId() + ":name=" + this.protocolMap.get(p.getProtoId()).getProtoName());
        }
        old = this.protocolByNameMap.putIfAbsent(p.getProtoName(), p);
        if (old != null) {
            this.protocolMap.remove(p.getProtoId());
            throw new ProtocolAlreadyExistsException("Protocol conflicts on name: " + p.getProtoName() + " (id: " + this.protocolByNameMap.get(p.getProtoName()).getProtoId() + ")");
        }
    }

    public void registerChannelInitializer(String name, ChannelInitializer<? extends IChannel<BabelMessage>> initializer) {
        ChannelInitializer<? extends IChannel<BabelMessage>> old = this.initializers.putIfAbsent(name, initializer);
        if (old != null) {
            throw new IllegalArgumentException("Initializer for channel with name " + name + " already registered: " + String.valueOf(old));
        }
    }

    int createChannel(String channelName, short protoId, Properties props) throws IOException {
        ChannelInitializer<? extends IChannel<BabelMessage>> initializer = this.initializers.get(channelName);
        if (initializer == null) {
            throw new IllegalArgumentException("Channel initializer not registered: " + channelName);
        }
        int channelId = this.channelIdGenerator.incrementAndGet();
        BabelMessageSerializer serializer = new BabelMessageSerializer(new ConcurrentHashMap<Short, ISerializer<? extends ProtoMessage>>());
        ChannelToProtoForwarder forwarder = new ChannelToProtoForwarder(channelId);
        IChannel<BabelMessage> newChannel = initializer.initialize(serializer, forwarder, props, protoId);
        this.channelMap.put(channelId, Triple.of(newChannel, forwarder, serializer));
        return channelId;
    }

    void registerChannelInterest(int channelId, short protoId, GenericProtocol consumerProto) {
        ChannelToProtoForwarder forwarder = this.channelMap.get(channelId).getMiddle();
        forwarder.addConsumer(protoId, consumerProto);
    }

    void sendMessage(int channelId, int connection, BabelMessage msg, Host target) {
        Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer> channelEntry = this.channelMap.get(channelId);
        if (channelEntry == null) {
            throw new AssertionError((Object)("Sending message to non-existing channelId " + channelId));
        }
        channelEntry.getLeft().sendMessage(msg, target, connection);
    }

    void closeConnection(int channelId, Host target, int connection) {
        Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer> channelEntry = this.channelMap.get(channelId);
        if (channelEntry == null) {
            throw new AssertionError((Object)("Closing connection in non-existing channelId " + channelId));
        }
        channelEntry.getLeft().closeConnection(target, connection);
    }

    void openConnection(int channelId, Host target, int connection) {
        Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer> channelEntry = this.channelMap.get(channelId);
        if (channelEntry == null) {
            throw new AssertionError((Object)("Opening connection in non-existing channelId " + channelId));
        }
        channelEntry.getLeft().openConnection(target, connection);
    }

    void registerSerializer(int channelId, short msgCode, ISerializer<? extends ProtoMessage> serializer) {
        Triple<IChannel<BabelMessage>, ChannelToProtoForwarder, BabelMessageSerializer> channelEntry = this.channelMap.get(channelId);
        if (channelEntry == null) {
            throw new AssertionError((Object)("Registering serializer in non-existing channelId " + channelId));
        }
        channelEntry.getRight().registerProtoSerializer(msgCode, serializer);
    }

    void sendIPC(IPCEvent ipc) throws NoSuchProtocolException {
        GenericProtocol gp = this.protocolMap.get(ipc.getDestinationID());
        if (gp == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ipc.getDestinationID()).append(" not executing.");
            sb.append("Executing protocols: [");
            this.protocolMap.forEach((id, p) -> sb.append(id).append(" - ").append(p.getProtoName()).append(", "));
            sb.append("]");
            throw new NoSuchProtocolException(sb.toString());
        }
        gp.deliverIPC(ipc);
    }

    void subscribeNotification(short nId, GenericProtocol consumer) {
        this.subscribers.computeIfAbsent(nId, k -> ConcurrentHashMap.newKeySet()).add(consumer);
    }

    void unsubscribeNotification(short nId, GenericProtocol consumer) {
        this.subscribers.getOrDefault(nId, Collections.emptySet()).remove(consumer);
    }

    void triggerNotification(NotificationEvent n) {
        for (GenericProtocol c : this.subscribers.getOrDefault(n.getNotification().getId(), Collections.emptySet())) {
            c.deliverNotification(n);
        }
    }

    long setupPeriodicTimer(ProtoTimer t2, GenericProtocol consumer, long first, long period) {
        long id = this.timersCounter.incrementAndGet();
        TimerEvent newTimer = new TimerEvent(t2, id, consumer, this.getMillisSinceStart() + first, true, period);
        this.allTimers.put(newTimer.getUuid(), newTimer);
        this.timerQueue.add(newTimer);
        this.timersThread.interrupt();
        return id;
    }

    long setupTimer(ProtoTimer t2, GenericProtocol consumer, long timeout) {
        long id = this.timersCounter.incrementAndGet();
        TimerEvent newTimer = new TimerEvent(t2, id, consumer, this.getMillisSinceStart() + timeout, false, -1L);
        this.timerQueue.add(newTimer);
        this.allTimers.put(newTimer.getUuid(), newTimer);
        this.timersThread.interrupt();
        return id;
    }

    ProtoTimer cancelTimer(long timerID) {
        TimerEvent tE = this.allTimers.remove(timerID);
        if (tE == null) {
            return null;
        }
        this.timerQueue.remove(tE);
        this.timersThread.interrupt();
        return tE.getTimer();
    }

    public static Properties loadConfig(String[] args, String defaultConfigFile) throws IOException, InvalidParameterException {
        props = new Properties(args.length);
        List<String> argsList = Arrays.asList(args);
        String configFile = Babel.extractConfigFileFromArguments(argsList, defaultConfigFile);
        logger.debug("config file being loaded: " + configFile);
        if (configFile != null) {
            InputStream in;
            block7: {
                in = null;
                try {
                    in = new FileInputStream(configFile);
                }
                catch (FileNotFoundException e) {
                    in = Babel.class.getResourceAsStream("/" + configFile);
                    if (in != null) break block7;
                    throw e;
                }
            }
            props.load(in);
            in.close();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("------ Config values: ------");
            for (Object key : props.keySet()) {
                logger.debug(String.valueOf(key) + ": " + String.valueOf(props.get(key)));
            }
            logger.debug("--- End of configuration ---");
        }
        for (String arg : argsList) {
            String[] property = arg.split("=");
            if (property.length == 2) {
                props.setProperty(property[0], property[1]);
                continue;
            }
            throw new InvalidParameterException("Unknown parameter: " + arg);
        }
        return props;
    }

    private static String extractConfigFileFromArguments(List<String> args, String defaultConfigFile) {
        String config = defaultConfigFile;
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!param.equals("-conf")) continue;
            if (!iter.hasNext()) break;
            iter.remove();
            config = iter.next();
            iter.remove();
            break;
        }
        return config;
    }

    public long getMillisSinceStart() {
        return this.started ? System.currentTimeMillis() - this.startTime : 0L;
    }
}

