/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.discovery;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.LocalDiscoveryProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;

public class MulticastDiscoveryProtocol
extends LocalDiscoveryProtocol {
    private static final Logger logger = LogManager.getLogger(MulticastDiscoveryProtocol.class);
    public static final int DEFAULT_MULTICAST_PORT = 1025;
    public static final int DEFAULT_UNICAST_PORT = 1026;
    public static final String MULTICAST_ADDRESS = "233.138.122.123";
    public static final int ANOUNCEMENT_COOLDOWN = 1000;
    public static final short PROTO_ID = 32500;
    public static final String PROTO_NAME = "BabelMulticastDiscovery";
    public static final String PAR_DISCOVERY_MULTICAST_INTERFACE = "babel.discovery.multicast.interface";
    public static final String PAR_DISCOVERY_MULTICAST_ADDRESS = "babel.discovery.multicast.addr";
    public static final String PAR_DISCOVERY_MULTICAST_PORT = "babel.discovery.multicast.port";
    private MulticastSocket multicastSocket;
    private InetSocketAddress multicastSocketAddress;
    private Thread listeningMulticastThread;
    private Thread listeningUnicastThread;

    public MulticastDiscoveryProtocol() {
        super(PROTO_NAME, (short)32500);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        super.init(props);
        if (!props.containsKey("babel.discovery.unicast.interface") && props.containsKey("babel.interface")) {
            props.put("babel.discovery.unicast.interface", props.get("babel.interface"));
        }
        if (!props.containsKey(PAR_DISCOVERY_MULTICAST_INTERFACE) && props.containsKey("babel.interface")) {
            props.put(PAR_DISCOVERY_MULTICAST_INTERFACE, props.get("babel.interface"));
        }
        if (!props.containsKey("babel.discovery.unicast.address") && props.containsKey("babel.address")) {
            props.put("babel.discovery.unicast.address", props.get("babel.address"));
        }
        int targetPort = 1025;
        if (props.containsKey(PAR_DISCOVERY_MULTICAST_PORT)) {
            targetPort = Integer.parseInt(props.getProperty(PAR_DISCOVERY_MULTICAST_PORT));
        }
        this.multicastSocketAddress = this.addInetSocketAddres(props.getProperty(PAR_DISCOVERY_MULTICAST_ADDRESS, MULTICAST_ADDRESS), targetPort);
        NetworkInterface networkInterface = !props.containsKey(PAR_DISCOVERY_MULTICAST_INTERFACE) ? NetworkInterface.networkInterfaces().filter(i -> {
            try {
                boolean supportsIPv4 = false;
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    if (!(addresses.nextElement() instanceof Inet4Address)) continue;
                    supportsIPv4 = true;
                    break;
                }
                return i.supportsMulticast() && supportsIPv4 && i.isUp() && !i.isLoopback();
            }
            catch (SocketException e) {
                e.printStackTrace();
                return false;
            }
        }).findAny().orElseThrow(() -> new RuntimeException("No network interface supports multicast")) : NetworkInterface.getByName(props.getProperty(PAR_DISCOVERY_MULTICAST_INTERFACE));
        this.multicastSocket = new MulticastSocket(targetPort);
        logger.debug("Multicast is going to use interface: " + networkInterface.getDisplayName());
        this.multicastSocket.joinGroup(this.multicastSocketAddress, networkInterface);
        logger.info("DiscoveryProtocol set up");
        InetAddress address = this.getAddressForSocket(props);
        int unicastPort = 1026;
        if (props.containsKey("babel.discovery.unicast.port")) {
            unicastPort = Integer.parseInt(props.getProperty("babel.discovery.unicast.port"));
        }
        DatagramSocket unicastSocket = this.setSocket(address, unicastPort, false);
        this.listeningMulticastThread = new Thread(() -> this.listen(this.multicastSocket));
        this.listeningUnicastThread = new Thread(() -> this.listen(unicastSocket));
        this.listeningMulticastThread.start();
        this.listeningUnicastThread.start();
        logger.info("DiscoveryProtocol initialized");
    }
}

