/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.generic.signed;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.generic.signed.SignedProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;

public abstract class SignedMessageSerializer<T extends SignedProtoMessage>
implements ISerializer<T> {
    @Override
    public void serialize(T msg, ByteBuf out) throws IOException {
        if (((SignedProtoMessage)msg).serializedMessage == null || ((SignedProtoMessage)msg).serializedMessage.length == 0) {
            ByteBuf serial = Unpooled.buffer();
            serial.writeShort(((ProtoMessage)msg).getId());
            this.serializeBody(msg, serial);
            ((SignedProtoMessage)msg).serializedMessage = ByteBufUtil.getBytes(serial.slice());
        }
        out.writeInt(((SignedProtoMessage)msg).serializedMessage.length);
        out.writeBytes(((SignedProtoMessage)msg).serializedMessage);
        if (((SignedProtoMessage)msg).signature == null || ((SignedProtoMessage)msg).signature.length == 0) {
            out.writeShort(0);
        } else {
            out.writeShort(((SignedProtoMessage)msg).signature.length);
            out.writeBytes(((SignedProtoMessage)msg).signature);
        }
    }

    @Override
    public T deserialize(ByteBuf in) throws IOException {
        int msgBodyLen = in.readInt();
        byte[] msgData = new byte[msgBodyLen];
        in.readBytes(msgData);
        T msg = this.deserializeBody(Unpooled.wrappedBuffer(msgData, 2, msgBodyLen - 2));
        ((SignedProtoMessage)msg).serializedMessage = msgData;
        short signatureSize = in.readShort();
        if (signatureSize > 0) {
            ((SignedProtoMessage)msg).signature = new byte[signatureSize];
            in.readBytes(((SignedProtoMessage)msg).signature);
        } else {
            ((SignedProtoMessage)msg).signature = null;
        }
        return msg;
    }

    public abstract void serializeBody(T var1, ByteBuf var2) throws IOException;

    public abstract T deserializeBody(ByteBuf var1) throws IOException;
}

