/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.hyparview;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.DiscoverableProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.DisconnectMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.ForwardJoinMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.JoinMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.JoinReplyMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.NeighborReplyMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.NeighborRequestMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.ShuffleMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.messages.ShuffleReplyMessage;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.timers.CheckConnectivityTimeout;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.timers.ShuffleTimer;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.utils.IView;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.utils.View;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;
import pt.unl.fct.di.novasys.babel.protocols.membership.requests.GetNeighborsSampleReply;
import pt.unl.fct.di.novasys.babel.protocols.membership.requests.GetNeighborsSampleRequest;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class HyParView
extends DiscoverableProtocol {
    private static final Logger logger = LogManager.getLogger(HyParView.class);
    public static final short PROTOCOL_ID = 1400;
    public static final String PROTOCOL_NAME = "HyParView";
    private static final int MAX_BACKOFF = 60000;
    private final short ARWL;
    private final short PRWL;
    private final short shuffleTime;
    private final short originalTimeout;
    private short timeout;
    private final short kActive;
    private final short kPassive;
    protected int channelId;
    protected final Host myself;
    protected IView active;
    protected IView passive;
    protected Set<Host> pending;
    private final Map<Short, Host[]> activeShuffles;
    private short seqNum = 0;
    protected final Random rnd;
    private boolean isReadyToStart;
    private boolean isStarted;
    public static final String PAR_ACTIVE_VIEW_SIZE = "HyParView.ActiveView";
    public static final String PAR_PASSIVE_VIEW_SIZE = "HyParView.PassiveView";
    public static final String PAR_ARWL = "HyParView.ARWL";
    public static final String PAR_PRWL = "HyParView.PRWL";
    public static final String PAR_SHUFFLE_PERIOD = "HyParView.ShufflePeriod";
    public static final String PAR_CHECK_CONNECTIVITY_PERIOD = "HyParView.CheckConnectivityPeriod";
    public static final String PAR_K_A = "HyParView.kActive";
    public static final String PAR_K_P = "HyParView.kPassive";
    public static final String PAR_CONTACT = "HyParView.contact";
    public static final String PAR_CHANNEL_ADDRESS = "HyParView.Channel.Address";
    public static final String PAR_CHANNEL_PORT = "HyParView.Channel.Port";

    public HyParView(String channelName, Properties properties, Host myself) throws IOException, HandlerRegistrationException {
        super(PROTOCOL_NAME, (short)1400, myself);
        this.myself = myself;
        int maxActive = Integer.parseInt(properties.getProperty(PAR_ACTIVE_VIEW_SIZE, "4"));
        int maxPassive = Integer.parseInt(properties.getProperty(PAR_PASSIVE_VIEW_SIZE, "7"));
        this.ARWL = Short.parseShort(properties.getProperty(PAR_ARWL, "4"));
        this.PRWL = Short.parseShort(properties.getProperty(PAR_PRWL, "2"));
        this.shuffleTime = Short.parseShort(properties.getProperty(PAR_SHUFFLE_PERIOD, "2000"));
        this.timeout = this.originalTimeout = Short.parseShort(properties.getProperty(PAR_CHECK_CONNECTIVITY_PERIOD, "1000"));
        this.kActive = Short.parseShort(properties.getProperty(PAR_K_A, "2"));
        this.kPassive = Short.parseShort(properties.getProperty(PAR_K_P, "3"));
        this.rnd = new Random();
        this.active = new View(maxActive, myself, this.rnd);
        this.passive = new View(maxPassive, myself, this.rnd);
        this.pending = new HashSet<Host>();
        this.activeShuffles = new TreeMap<Short, Host[]>();
        this.active.setOther(this.passive, this.pending);
        this.passive.setOther(this.active, this.pending);
        Properties channelProps = new Properties();
        if (properties.containsKey(PAR_CHANNEL_ADDRESS) && properties.containsKey(PAR_CHANNEL_PORT)) {
            String address = properties.getProperty(PAR_CHANNEL_ADDRESS);
            String port = properties.getProperty(PAR_CHANNEL_PORT);
            channelProps.setProperty("address", address);
            channelProps.setProperty("port", port);
            this.channelId = this.createChannel("TCPChannel", channelProps);
        } else {
            if (this.myself == null) {
                throw new RuntimeException("Cannot determine the interface and address to bind to");
            }
            channelProps.setProperty("address", this.myself.getAddress().getHostAddress());
            channelProps.setProperty("port", "" + this.myself.getPort());
            this.channelId = this.createChannel("TCPChannel", channelProps);
        }
        this.setDefaultChannel(this.channelId);
        if (properties.containsKey(PAR_CONTACT)) {
            String contact = properties.getProperty(PAR_CONTACT).trim();
            if (!contact.isEmpty() && !contact.equalsIgnoreCase("none")) {
                try {
                    String[] hostElems = contact.split(":");
                    Host c = new Host(InetAddress.getByName(hostElems[0]), Short.parseShort(hostElems[1]));
                    this.addContact(c);
                }
                catch (Exception e) {
                    System.err.println("Invalid contact on configuration: '" + properties.getProperty("contacts"));
                    e.printStackTrace();
                    System.exit(-1);
                }
            } else {
                this.isReadyToStart = true;
            }
        } else {
            logger.debug("No contact information, standing by discovery of a contact to start.");
            this.isReadyToStart = false;
        }
        this.isStarted = false;
        this.registerMessageSerializer(this.channelId, (short)1401, JoinMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)1402, JoinReplyMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)1403, ForwardJoinMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)1405, NeighborRequestMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)1406, NeighborReplyMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)1404, DisconnectMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)1407, ShuffleMessage.serializer);
        this.registerMessageSerializer(this.channelId, (short)1408, ShuffleReplyMessage.serializer);
        this.registerMessageHandler(this.channelId, (short)1401, this::uponReceiveJoin);
        this.registerMessageHandler(this.channelId, (short)1402, this::uponReceiveJoinReply);
        this.registerMessageHandler(this.channelId, (short)1403, this::uponReceiveForwardJoin);
        this.registerMessageHandler(this.channelId, (short)1405, this::uponRNeeighborRequest);
        this.registerMessageHandler(this.channelId, (short)1406, this::uponReceiveNeighborReply);
        this.registerMessageHandler(this.channelId, (short)1404, this::uponReceiveDisconnect, this::uponDisconnectSent);
        this.registerMessageHandler(this.channelId, (short)1407, this::uponShuffle);
        this.registerMessageHandler(this.channelId, (short)1408, this::uponReceiveShuffleReply, this::uponShuffleReplySent);
        this.registerRequestHandler((short)401, this::uponGetSampleRequest);
        this.registerTimerHandler((short)401, this::uponShuffleTimer);
        this.registerTimerHandler((short)402, this::uponCheckConnectivityTimer);
        this.registerChannelEventHandler(this.channelId, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(this.channelId, (short)4, this::uponOutConnectionFailed);
        this.registerChannelEventHandler(this.channelId, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)1, this::uponInConnectionDown);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        if (this.isReadyToStart) {
            this.start();
        }
    }

    private void uponGetSampleRequest(GetNeighborsSampleRequest req, short protoID) {
        if (req.getSampleSize() <= this.active.getCapacity()) {
            this.sendReply(new GetNeighborsSampleReply(this.active.getPeers()), protoID);
            return;
        }
        SecureRandom r = new SecureRandom();
        HashSet<Host> candidates = new HashSet<Host>(this.active.getPeers());
        while (candidates.size() > req.getSampleSize()) {
            candidates.remove(candidates.toArray()[r.nextInt(candidates.size())]);
        }
        this.sendReply(new GetNeighborsSampleReply((Set<? extends Host>)candidates), protoID);
    }

    public int getChannel() {
        return this.channelId;
    }

    protected void handleDropFromActive(Host dropped) {
        if (dropped != null) {
            this.triggerNotification(new NeighborDown(dropped, false));
            this.sendMessage(new DisconnectMessage(), dropped);
            logger.debug("Sent DisconnectMessage to {}", (Object)dropped);
            this.passive.addPeer(dropped);
            logger.trace("Added to {} passive{}", (Object)dropped, (Object)this.passive);
        }
    }

    private void uponReceiveJoin(JoinMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        Host h2 = this.active.addPeer(from);
        logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
        this.openConnection(from);
        this.triggerNotification(new NeighborUp(from));
        this.sendMessage(new JoinReplyMessage(), from);
        logger.debug("Sent JoinReplyMessage to {}", (Object)from);
        this.handleDropFromActive(h2);
        for (Host peer : this.active.getPeers()) {
            if (peer.equals(from)) continue;
            this.sendMessage(new ForwardJoinMessage(this.ARWL, from), peer);
            logger.debug("Sent ForwardJoinMessage to {}", (Object)peer);
        }
    }

    private void uponReceiveJoinReply(JoinReplyMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        if (!this.active.containsPeer(from)) {
            this.passive.removePeer(from);
            this.pending.remove(from);
            Host h2 = this.active.addPeer(from);
            this.openConnection(from);
            logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
            this.triggerNotification(new NeighborUp(from));
            this.handleDropFromActive(h2);
        }
    }

    private void uponReceiveForwardJoin(ForwardJoinMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        if (msg.decrementTtl() == 0 || this.active.getPeers().size() == 1) {
            if (!msg.getNewHost().equals(this.myself) && !this.active.containsPeer(msg.getNewHost())) {
                this.passive.removePeer(msg.getNewHost());
                this.pending.remove(msg.getNewHost());
                Host h2 = this.active.addPeer(msg.getNewHost());
                logger.trace("Added to {} active{}", (Object)msg.getNewHost(), (Object)this.active);
                this.openConnection(msg.getNewHost());
                this.triggerNotification(new NeighborUp(msg.getNewHost()));
                this.sendMessage(new JoinReplyMessage(), msg.getNewHost());
                logger.debug("Sent JoinReplyMessage to {}", (Object)msg.getNewHost());
                this.handleDropFromActive(h2);
            }
        } else {
            Host next;
            if (msg.getTtl() == this.PRWL) {
                this.passive.addPeer(msg.getNewHost());
                logger.trace("Added to {} passive{}", (Object)from, (Object)this.passive);
            }
            if ((next = this.active.getRandomDiff(from, msg.getNewHost())) != null) {
                this.sendMessage(msg, next);
                logger.debug("Sent ForwardJoinMessage to {}", (Object)next);
            }
        }
    }

    private void uponRNeeighborRequest(NeighborRequestMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        if (msg.isPriority()) {
            if (!this.active.containsPeer(from)) {
                this.pending.remove(from);
                logger.trace("Removed from {} pending{}", (Object)from, (Object)this.pending);
                this.passive.removePeer(from);
                logger.trace("Removed from {} passive{}", (Object)from, (Object)this.passive);
                Host h2 = this.active.addPeer(from);
                logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
                this.openConnection(from);
                this.triggerNotification(new NeighborUp(from));
                this.handleDropFromActive(h2);
            }
            this.sendMessage(new NeighborReplyMessage(true), from);
            logger.debug("Sent NeighborReplyMessage to {}", (Object)from);
        } else {
            this.pending.remove(from);
            logger.trace("Removed from {} pending{}", (Object)from, (Object)this.pending);
            if (!this.active.fullWithPending(this.pending) || this.active.containsPeer(from)) {
                if (!this.active.containsPeer(from)) {
                    this.passive.removePeer(from);
                    logger.trace("Removed from {} passive{}", (Object)from, (Object)this.passive);
                    this.active.addPeer(from);
                    logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
                    this.openConnection(from);
                    this.triggerNotification(new NeighborUp(from));
                }
                this.sendMessage(new NeighborReplyMessage(true), from);
                logger.debug("Sent NeighborReplyMessage to {}", (Object)from);
            } else {
                this.sendMessage((ProtoMessage)new NeighborReplyMessage(false), from, 1);
                logger.debug("Sent NeighborReplyMessage to {}", (Object)from);
            }
        }
    }

    private void uponReceiveNeighborReply(NeighborReplyMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        this.pending.remove(from);
        logger.trace("Removed from {} pending{}", (Object)from, (Object)this.pending);
        if (msg.isTrue()) {
            if (!this.active.containsPeer(from)) {
                this.timeout = this.originalTimeout;
                Host h2 = this.active.addPeer(from);
                logger.trace("Added to {} active{}", (Object)from, (Object)this.active);
                this.openConnection(from);
                this.triggerNotification(new NeighborUp(from));
                this.handleDropFromActive(h2);
            }
        } else if (!this.active.containsPeer(from)) {
            this.passive.addPeer(from);
            this.closeConnection(from);
            logger.trace("Added to {} passive{}", (Object)from, (Object)this.passive);
            if (!this.active.fullWithPending(this.pending)) {
                this.setupTimer(new CheckConnectivityTimeout(), this.timeout);
            }
        }
    }

    private void uponReceiveDisconnect(DisconnectMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        if (this.active.containsPeer(from)) {
            this.active.removePeer(from);
            logger.trace("Removed from {} active{}", (Object)from, (Object)this.active);
            this.handleDropFromActive(from);
            if (this.active.getPeers().isEmpty()) {
                this.timeout = this.originalTimeout;
            }
            if (!this.active.fullWithPending(this.pending)) {
                this.setupTimer(new CheckConnectivityTimeout(), this.timeout);
            }
        }
    }

    private void uponDisconnectSent(DisconnectMessage msg, Host host, short destProto, int channelId) {
        logger.trace("Sent {} to {}", (Object)msg, (Object)host);
        this.closeConnection(host);
    }

    private void uponShuffle(ShuffleMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        Host next = this.active.getRandomDiff(from, msg.getOrigin());
        if (msg.decrementTtl() > 0 && next != null) {
            this.sendMessage(msg, next);
            logger.debug("Sent ShuffleMessage to {}", (Object)next);
        } else {
            Host[] tmp;
            logger.trace("Processing {}, passive{}", (Object)msg, (Object)this.passive);
            HashSet<Host> peers = new HashSet<Host>();
            peers.addAll(this.passive.getRandomSample(1 + this.kActive + this.kPassive));
            Host[] hosts = peers.toArray(new Host[peers.size()]);
            if (!this.active.containsPeer(msg.getOrigin()) && !this.pending.contains(msg.getOrigin())) {
                this.openConnection(msg.getOrigin());
            }
            this.sendMessage(new ShuffleReplyMessage(peers, msg.getSeqnum()), msg.getOrigin());
            logger.debug("Sent ShuffleReplyMessage to {}", (Object)msg.getOrigin());
            List<Host> shuffleSample = msg.getFullSample();
            for (Host h2 : tmp = shuffleSample.toArray(new Host[shuffleSample.size()])) {
                if (!h2.equals(this.myself) && !this.active.containsPeer(h2) && !this.passive.containsPeer(h2)) continue;
                shuffleSample.remove(h2);
            }
            for (int i = 0; i < hosts.length && this.passive.getPeers().size() + shuffleSample.size() > this.passive.getCapacity(); ++i) {
                this.passive.removePeer(hosts[i]);
            }
            while (this.passive.getPeers().size() + shuffleSample.size() > this.passive.getCapacity()) {
                this.passive.dropRandom();
            }
            for (Host h3 : shuffleSample) {
                this.passive.addPeer(h3);
            }
            logger.trace("After Passive{}", (Object)this.passive);
        }
    }

    private void uponShuffleReplySent(ShuffleReplyMessage msg, Host host, short destProto, int channelId) {
        if (!this.active.containsPeer(host) && !this.pending.contains(host)) {
            logger.trace("Disconnecting from {} after shuffleReply", (Object)host);
            this.closeConnection(host);
        }
    }

    private void uponReceiveShuffleReply(ShuffleReplyMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received {} from {}", (Object)msg, (Object)from);
        Host[] sent = this.activeShuffles.remove(msg.getSeqnum());
        if (sent == null) {
            sent = new Host[]{};
        }
        List<Host> sample = msg.getSample();
        for (Host h2 : sample.toArray(new Host[sample.size()])) {
            if (!h2.equals(this.myself) && !this.active.containsPeer(h2) && !this.passive.containsPeer(h2)) continue;
            sample.remove(h2);
        }
        for (int i = 0; i < sent.length && this.passive.getPeers().size() + sample.size() > this.passive.getCapacity(); ++i) {
            this.passive.removePeer(sent[i]);
        }
        while (this.passive.getPeers().size() + sample.size() > this.passive.getCapacity()) {
            this.passive.dropRandom();
        }
        for (Host h3 : sample) {
            this.passive.addPeer(h3);
        }
        logger.trace("After Passive{}", (Object)this.passive);
    }

    private void uponShuffleTimer(ShuffleTimer timer, long timerId) {
        Host h2;
        if (!this.active.fullWithPending(this.pending)) {
            this.setupTimer(new CheckConnectivityTimeout(), this.timeout);
        }
        if ((h2 = this.active.getRandom()) != null) {
            HashSet<Host> peers = new HashSet<Host>();
            peers.addAll(this.active.getRandomSample(this.kActive));
            peers.addAll(this.passive.getRandomSample(this.kPassive));
            this.activeShuffles.put(this.seqNum, peers.toArray(new Host[peers.size()]));
            this.sendMessage(new ShuffleMessage(this.myself, peers, this.ARWL, this.seqNum), h2);
            logger.debug("Sent ShuffleMessage to {}", (Object)h2);
            this.seqNum = (short)((short)(this.seqNum % Short.MAX_VALUE) + 1);
        }
    }

    private void uponCheckConnectivityTimer(CheckConnectivityTimeout timer, long timerId) {
        if (!this.active.fullWithPending(this.pending)) {
            Host h2 = this.passive.dropRandom();
            if (h2 != null && this.pending.add(h2)) {
                logger.trace("Sending HelloMessage to {}, pending {}, active {}, passive {}", (Object)h2, (Object)this.pending, (Object)this.active, (Object)this.passive);
                this.openConnection(h2);
                this.sendMessage(new NeighborRequestMessage(this.getPriority()), h2);
                logger.debug("Sent HelloMessage to {}", (Object)h2);
                this.timeout = (short)Math.min(this.timeout * 2, 60000);
            } else if (h2 != null) {
                this.passive.addPeer(h2);
            }
        }
    }

    private boolean getPriority() {
        return this.active.getPeers().size() + this.pending.size() == 1;
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channelId) {
        logger.trace("Host {} is down, active{}, cause: {}", (Object)event.getNode(), (Object)this.active, (Object)event.getCause());
        if (this.active.removePeer(event.getNode())) {
            this.triggerNotification(new NeighborDown(event.getNode(), true));
            if (!this.active.fullWithPending(this.pending)) {
                this.setupTimer(new CheckConnectivityTimeout(), this.timeout);
            }
        } else {
            this.pending.remove(event.getNode());
        }
    }

    private void uponOutConnectionFailed(OutConnectionFailed<?> event, int channelId) {
        logger.trace("Connection to host {} failed, cause: {}", (Object)event.getNode(), (Object)event.getCause());
        if (this.active.removePeer(event.getNode())) {
            this.triggerNotification(new NeighborDown(event.getNode(), true));
            if (!this.active.fullWithPending(this.pending)) {
                this.setupTimer(new CheckConnectivityTimeout(), this.timeout);
            }
        } else {
            this.pending.remove(event.getNode());
        }
    }

    private void uponOutConnectionUp(OutConnectionUp event, int channelId) {
        logger.trace("Host (out) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionUp(InConnectionUp event, int channelId) {
        logger.trace("Host (in) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionDown(InConnectionDown event, int channelId) {
        logger.trace("Connection from host {} is down, active{}, cause: {}", (Object)event.getNode(), (Object)this.active, (Object)event.getCause());
    }

    @Override
    public void start() {
        if (this.isStarted) {
            return;
        }
        this.setupPeriodicTimer(new ShuffleTimer(), this.shuffleTime, this.shuffleTime);
        this.isStarted = true;
    }

    @Override
    public boolean readyToStart() {
        logger.debug("HyParView: checking if is ready to start with answer: " + this.isReadyToStart);
        return this.isReadyToStart;
    }

    @Override
    public boolean needsDiscovery() {
        logger.debug("HyParView: checking if needs discovery with answer: " + !this.isReadyToStart);
        return !this.isReadyToStart;
    }

    @Override
    public void addContact(Host host) {
        this.openConnection(host);
        JoinMessage m4 = new JoinMessage();
        this.sendMessage(m4, host);
        this.isReadyToStart = true;
        logger.debug("Sent JoinMessage to {}", (Object)host);
        logger.trace("Sent " + String.valueOf(m4) + " to " + String.valueOf(host));
    }
}

