/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.ackos.messaging;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosAckMessage;
import pt.unl.fct.di.novasys.channel.ackos.messaging.AckosAppMessage;
import pt.unl.fct.di.novasys.network.ISerializer;

public abstract class AckosMessage<T> {
    private Type type;

    public AckosMessage(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        APP_MSG(0, AckosAppMessage.serializer),
        ACK(1, AckosAckMessage.serializer);

        public final int opCode;
        public final IAckosSerializer<AckosMessage> serializer;
        private static final Type[] opcodeIdx;

        private Type(int opCode, IAckosSerializer<AckosMessage> serializer) {
            this.opCode = opCode;
            this.serializer = serializer;
        }

        public static Type fromOpcode(int opcode) {
            if (opcode >= opcodeIdx.length || opcode < 0) {
                throw new AssertionError((Object)String.format("Unknown opcode %d", opcode));
            }
            Type t2 = opcodeIdx[opcode];
            if (t2 == null) {
                throw new AssertionError((Object)String.format("Unknown opcode %d", opcode));
            }
            return t2;
        }

        static {
            int maxOpcode = -1;
            for (Type type : Type.values()) {
                maxOpcode = Math.max(maxOpcode, type.opCode);
            }
            opcodeIdx = new Type[maxOpcode + 1];
            for (Type type : Type.values()) {
                if (opcodeIdx[type.opCode] != null) {
                    throw new IllegalStateException("Duplicate opcode");
                }
                Type.opcodeIdx[type.opCode] = type;
            }
        }
    }

    public static interface IAckosSerializer<T extends AckosMessage> {
        public void serialize(T var1, ByteBuf var2, ISerializer var3) throws IOException;

        public T deserialize(ByteBuf var1, ISerializer var2) throws IOException;
    }
}

