/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.data;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class Attributes {
    public static Attributes EMPTY = new Attributes();
    private Map<String, byte[]> attrMap;
    public static ISerializer<Attributes> serializer = new ISerializer<Attributes>(){

        @Override
        public void serialize(Attributes attributes, ByteBuf out) {
            out.writeInt(attributes.attrMap.size());
            for (Map.Entry e : attributes.attrMap.entrySet()) {
                int keySize = ByteBufUtil.utf8Bytes((CharSequence)e.getKey());
                out.writeInt(keySize);
                ByteBufUtil.reserveAndWriteUtf8(out, (CharSequence)e.getKey(), keySize);
                out.writeInt(((byte[])e.getValue()).length);
                out.writeBytes((byte[])e.getValue());
            }
        }

        @Override
        public Attributes deserialize(ByteBuf in) {
            int mapSize = in.readInt();
            HashMap<String, byte[]> attrMap = new HashMap<String, byte[]>();
            for (int i = 0; i < mapSize; ++i) {
                int keySize = in.readInt();
                String key = in.readCharSequence(keySize, StandardCharsets.UTF_8).toString();
                int valueSize = in.readInt();
                byte[] bytes = new byte[valueSize];
                in.readBytes(bytes);
                attrMap.put(key, bytes);
            }
            return new Attributes(attrMap);
        }
    };

    public Attributes() {
        this(new HashMap<String, byte[]>());
    }

    public Attributes(Map<String, byte[]> initialValues) {
        this.attrMap = new HashMap<String, byte[]>(initialValues);
    }

    public Attributes shallowClone() {
        return new Attributes(new HashMap<String, byte[]>(this.attrMap));
    }

    public Attributes deepClone() {
        HashMap<String, byte[]> newMap = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> e : this.attrMap.entrySet()) {
            newMap.put(e.getKey(), Arrays.copyOf(e.getValue(), e.getValue().length));
        }
        return new Attributes(newMap);
    }

    public Set<String> getKeys() {
        return this.attrMap.keySet();
    }

    public boolean containsKey(String key) {
        return this.attrMap.containsKey(key);
    }

    public <T> void putObject(String key, T value, ISerializer<T> serializer) throws IOException {
        ByteBuf buffer = Unpooled.buffer();
        serializer.serialize(value, buffer);
        this.attrMap.put(key, buffer.array());
    }

    public <T> T getObject(String key, ISerializer<T> serializer) throws IOException {
        byte[] bytes = this.attrMap.get(key);
        if (bytes == null) {
            return null;
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer(bytes);
        return serializer.deserialize(byteBuf);
    }

    public void putBoolean(String key, boolean value) {
        this.attrMap.put(key, new byte[]{(byte)(value ? 1 : 0)});
    }

    public Boolean getBoolean(String key) {
        byte[] bytes = this.attrMap.get(key);
        if (bytes == null) {
            return null;
        }
        return bytes[0] != 0;
    }

    public void putShort(String key, short value) {
        this.attrMap.put(key, ByteBuffer.allocate(2).putShort(value).array());
    }

    public Short getShort(String key) {
        byte[] bytes = this.attrMap.get(key);
        if (bytes == null) {
            return null;
        }
        return ByteBuffer.wrap(bytes).getShort();
    }

    public void putInt(String key, int value) {
        this.attrMap.put(key, ByteBuffer.allocate(4).putInt(value).array());
    }

    public Integer getInt(String key) {
        byte[] bytes = this.attrMap.get(key);
        if (bytes == null) {
            return null;
        }
        return ByteBuffer.wrap(bytes).getInt();
    }

    public void putLong(String key, long value) {
        this.attrMap.put(key, ByteBuffer.allocate(8).putLong(value).array());
    }

    public Long getLong(String key) {
        byte[] bytes = this.attrMap.get(key);
        if (bytes == null) {
            return null;
        }
        return ByteBuffer.wrap(bytes).getLong();
    }

    public void putFloat(String key, float value) {
        this.attrMap.put(key, ByteBuffer.allocate(4).putFloat(value).array());
    }

    public Float getFloat(String key) {
        byte[] bytes = this.attrMap.get(key);
        if (bytes == null) {
            return null;
        }
        return Float.valueOf(ByteBuffer.wrap(bytes).getFloat());
    }

    public void putString(String key, String value) {
        this.attrMap.put(key, value.getBytes(StandardCharsets.UTF_8));
    }

    public String getString(String key) {
        byte[] bytes = this.attrMap.get(key);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void putHost(String key, Host value) throws IOException {
        ByteBuf buffer = Unpooled.buffer(6);
        Host.serializer.serialize(value, buffer);
        this.attrMap.put(key, buffer.array());
    }

    public Host getHost(String key) throws IOException {
        byte[] bytes = this.attrMap.get(key);
        if (bytes == null) {
            return null;
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer(bytes);
        return Host.serializer.deserialize(byteBuf);
    }

    public String toString() {
        return "Attributes{" + this.attrMap.keySet() + '}';
    }
}

