/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.messaging.control;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;

public class SecondHandshakeMessage
extends ControlMessage {
    static ControlMessage.ControlMessageSerializer serializer = new ControlMessage.ControlMessageSerializer<SecondHandshakeMessage>(){

        @Override
        public void serialize(SecondHandshakeMessage msg, ByteBuf out) throws IOException {
            out.writeInt(msg.magicNumber);
            Attributes.serializer.serialize(msg.attributes, out);
        }

        @Override
        public SecondHandshakeMessage deserialize(ByteBuf in) throws IOException {
            int magicNumber = in.readInt();
            if (magicNumber != 2036819058) {
                throw new RuntimeException("Invalid magic number: " + magicNumber);
            }
            Attributes attributes = Attributes.serializer.deserialize(in);
            return new SecondHandshakeMessage(magicNumber, attributes);
        }
    };
    public final int magicNumber;
    public final Attributes attributes;

    public SecondHandshakeMessage(Attributes attrs) {
        this(2036819058, attrs);
    }

    public SecondHandshakeMessage(int magicNumber, Attributes attrs) {
        super(ControlMessage.Type.SECOND_HS);
        this.magicNumber = magicNumber;
        this.attributes = attrs;
    }

    public String toString() {
        return "SecondHandshakeMessage{attributes=" + this.attributes + "magicNumber=" + this.magicNumber + '}';
    }
}

