/*
 * Decompiled with CFR 0.152.
 */
package tardis.app;

import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.notifications.BroadcastDelivery;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.requests.BroadcastRequest;
import pt.unl.fct.di.novasys.network.data.Host;
import tardis.app.timers.AppWorkloadGenerateTimer;

public class DataDisseminationApp
extends GenericProtocol {
    public static final String PROTO_NAME = "TaRDIS Simple App";
    public static final short PROTO_ID = 9999;
    public static final String PAR_GRAPHICS = "app.graphics";
    private boolean loadGraphicalInterface;
    public static final String PAR_GENERATE_WORKLOAD = "app.automatic";
    private boolean generateWorkload;
    public static final String PAR_WORKLOAD_PERIOD = "app.workload.period";
    public static final String PAR_WOKRLOAD_SIZE = "app.workload.payload";
    public static final long DEFAULT_WORKLOAD_PERIOD = 10000L;
    public static final int DEFAULT_WORKLOAD_SIZE = 63000;
    public static final String PAR_BCAST_PROTOCOL_ID = "app.bcast.id";
    private long workloadPeriod;
    private int payloadSize;
    private short bcastProtoID;
    private final Host myself;
    private Logger logger = LogManager.getLogger(DataDisseminationApp.class);

    public DataDisseminationApp(Host myself) throws HandlerRegistrationException {
        super(PROTO_NAME, (short)9999);
        this.myself = myself;
        this.registerTimerHandler((short)9999, this::handleAppWorkloadGenerateTimer);
        this.subscribeNotification((short)501, this::handleDMessageDeliveryEvent);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.loadGraphicalInterface = props.containsKey(PAR_GRAPHICS);
        if (this.loadGraphicalInterface) {
            this.logger.debug("DataDisseminationApp is configured to provide a graphical interface.");
            this.logger.info("Graphical Interactive mode requested: This functionality is not yet implemented!");
        }
        if (props.containsKey(PAR_BCAST_PROTOCOL_ID)) {
            this.bcastProtoID = Short.parseShort(props.getProperty(PAR_BCAST_PROTOCOL_ID));
            this.logger.debug("DataDisseminationApp is configured to used broadcast protocol with id: " + this.bcastProtoID);
        } else {
            this.logger.error("The applicaiton requires the id of the broadcast protocol being used. Parameter: 'app.bcast.id'");
            System.exit(1);
        }
        this.generateWorkload = props.containsKey(PAR_GENERATE_WORKLOAD);
        if (this.generateWorkload) {
            this.workloadPeriod = props.containsKey(PAR_WORKLOAD_PERIOD) ? Long.parseLong(props.getProperty(PAR_WORKLOAD_PERIOD)) : 10000L;
            this.payloadSize = props.containsKey(PAR_WOKRLOAD_SIZE) ? Integer.parseInt(PAR_WOKRLOAD_SIZE) : 63000;
            this.setupPeriodicTimer(new AppWorkloadGenerateTimer(), this.workloadPeriod, this.workloadPeriod);
            this.logger.debug("DataDisseminationApp has workload generation enabled.");
        } else {
            this.logger.debug("DataDisseminationApp has workload generation disabled.");
        }
    }

    private void handleAppWorkloadGenerateTimer(AppWorkloadGenerateTimer t2, long time) {
        this.logger.debug("DataDisseminationApp generating workload.");
        String payload = DataDisseminationApp.randomCapitalLetters(this.payloadSize);
        BroadcastRequest request = new BroadcastRequest(this.myself, payload.getBytes(), 9999);
        this.sendRequest(request, this.bcastProtoID);
        this.logger.info(String.valueOf(this.myself) + " sent message: [" + String.valueOf(this.myself) + "::::" + DataDisseminationApp.readableOutput(payload) + "]");
    }

    private void handleDMessageDeliveryEvent(BroadcastDelivery msg, short proto) {
        String payload = new String(msg.getPayload());
        this.logger.info(String.valueOf(this.myself) + " recv message: [" + String.valueOf(msg.getSender()) + "::::" + DataDisseminationApp.readableOutput(payload) + "]");
    }

    public static String randomCapitalLetters(int length) {
        int leftLimit = 65;
        int rightLimit = 90;
        Random random = new Random();
        return random.ints(leftLimit, rightLimit + 1).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String readableOutput(String msg) {
        if (msg.length() > 32) {
            return Hashing.sha256().hashString(msg, StandardCharsets.UTF_8).toString();
        }
        return msg;
    }
}

