/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.InetAddress;
import java.util.Properties;
import jnr.constants.platform.Signal;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.SignalHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.micro.protocols.discovery.MicroBabelDiscoveryProtocol;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.IoTRemoteControlProtocol;
import pt.unl.fct.di.novasys.babel.protocols.antientropy.AntiEntropy;
import pt.unl.fct.di.novasys.babel.protocols.eagerpush.EagerPushGossipBroadcast;
import pt.unl.fct.di.novasys.babel.protocols.hyparview.HyParView;
import pt.unl.fct.di.novasys.babel.utils.NetworkingUtilities;
import pt.unl.fct.di.novasys.babel.utils.memebership.monitor.MembershipMonitor;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.RandomTour.RandomTour;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.DigitalOutputControlProtocol;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.I2COutputControlProtocol;
import tardis.app.DataDisseminationApp;

public class Main
implements SignalHandler {
    private static final Logger logger;
    private static final String DEFAULT_CONF = "tardis.conf";
    private final DataDisseminationApp app;

    public Main(DataDisseminationApp app) {
        this.app = app;
    }

    public static void main(String[] args) throws Exception {
        logger.info("Starting...");
        Babel babel = Babel.getInstance();
        if (new File(DEFAULT_CONF).exists()) {
            System.err.println("The config file: tardis.conf is not accessible.");
            System.exit(1);
        }
        Properties props = Babel.loadConfig(args, DEFAULT_CONF);
        String address = null;
        if (props.containsKey("babel.interface")) {
            address = NetworkingUtilities.getAddress(props.getProperty("babel.interface"));
        } else if (props.containsKey("babel.address")) {
            address = props.getProperty("babel.address");
        }
        int port = -1;
        if (props.containsKey("babel.port")) {
            port = Integer.parseInt(props.getProperty("babel.port"));
        }
        Host h2 = null;
        if (address == null || port == -1) {
            System.err.println("Configuration must contain one of 'babel.interface' or 'babel.address' and the 'babel.port'");
            System.exit(1);
        }
        h2 = new Host(InetAddress.getByName(address), port);
        HyParView hyparview = new HyParView("channel.hyparview", props, h2);
        MembershipMonitor mm4 = new MembershipMonitor();
        Host gossipHost = new Host(h2.getAddress(), h2.getPort() + 1);
        EagerPushGossipBroadcast bcast = new EagerPushGossipBroadcast("channel.gossip", props, gossipHost);
        AntiEntropy at = new AntiEntropy(props, null);
        RandomTour randomTour = new RandomTour(props, null);
        DigitalOutputControlProtocol diot = new DigitalOutputControlProtocol();
        I2COutputControlProtocol iot = new I2COutputControlProtocol();
        IoTRemoteControlProtocol iotRemote = new IoTRemoteControlProtocol(gossipHost);
        MicroBabelDiscoveryProtocol mbd = new MicroBabelDiscoveryProtocol();
        final DataDisseminationApp app = new DataDisseminationApp(gossipHost);
        props.putIfAbsent("app.bcast.id", "1600");
        babel.registerProtocol(hyparview);
        System.out.println("Loaded: " + hyparview.getProtoName() + " " + hyparview.getProtoId());
        babel.registerProtocol(mm4);
        System.out.println("Loaded: " + mm4.getProtoName() + " " + mm4.getProtoId());
        babel.registerProtocol(bcast);
        System.out.println("Loaded: " + bcast.getProtoName() + " " + bcast.getProtoId());
        babel.registerProtocol(at);
        System.out.println("Loaded: " + at.getProtoName() + " " + at.getProtoId());
        babel.registerProtocol(randomTour);
        System.out.println("Loaded: " + randomTour.getProtoName() + " " + randomTour.getProtoId());
        babel.registerProtocol(iot);
        System.out.println("Loaded: " + iot.getProtoName() + " " + iot.getProtoId());
        babel.registerProtocol(diot);
        System.out.println("Loaded: " + diot.getProtoName() + " " + diot.getProtoId());
        babel.registerProtocol(iotRemote);
        System.out.println("Loaded: " + iotRemote.getProtoName() + " " + iotRemote.getProtoId());
        babel.registerProtocol(mbd);
        System.out.println("Loaded: " + mbd.getProtoName() + " " + mbd.getProtoId());
        babel.registerProtocol(app);
        System.out.println("Loaded: " + app.getProtoName() + " " + app.getProtoId());
        hyparview.init(props);
        mm4.init(props);
        bcast.init(props);
        at.init(props);
        randomTour.init(props);
        iot.init(props);
        diot.init(props);
        iotRemote.init(props);
        mbd.init(props);
        app.init(props);
        System.out.println("Setup is complete.");
        babel.start();
        System.out.println("System is running.");
        if (!System.getProperty("os.name").contains("Windows")) {
            POSIX posix = POSIXFactory.getJavaPOSIX();
            Main m4 = new Main(app);
            posix.signal(Signal.SIGUSR1, m4);
            posix.signal(Signal.SIGUSR2, m4);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                app.shutdown();
                logger.info("Received shutdown. Disabled data transmission.");
                logger.info("Shuting down now.");
            }
        });
    }

    @Override
    public void handle(int signal) {
        if (this.app.isTransmitting()) {
            try {
                this.app.disableTransmissions();
                logger.info("Received shutdown. Disabled data transmission.");
                logger.info("Shuting down in 60 seconds.");
                Thread.sleep(600000L);
                System.exit(0);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
        } else {
            this.app.enableTransmission();
            logger.info("Starting to generate data.");
        }
    }

    static {
        System.setProperty("log4j.configurationFile", "log4j2.xml");
        System.setProperty("java.net.preferIPv4Stack", "true");
        logger = LogManager.getLogger(Main.class);
    }
}

