/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.metadata.schema;

import com.datastax.dse.driver.api.core.metadata.schema.DseKeyspaceMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;

public interface DseGraphKeyspaceMetadata
extends DseKeyspaceMetadata {
    @NonNull
    public Optional<String> getGraphEngine();

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        if (this.isVirtual()) {
            builder.append("/* VIRTUAL ");
        } else {
            builder.append("CREATE ");
        }
        builder.append("KEYSPACE ").append(this.getName()).append(" WITH replication = { 'class' : '").append(this.getReplication().get("class")).append("'");
        for (Map.Entry<String, String> entry : this.getReplication().entrySet()) {
            if (entry.getKey().equals("class")) continue;
            builder.append(", '").append(entry.getKey()).append("': '").append(entry.getValue()).append("'");
        }
        builder.append(" } AND durable_writes = ").append(Boolean.toString(this.isDurableWrites()));
        this.getGraphEngine().ifPresent(graphEngine -> builder.append(" AND graph_engine ='").append((String)graphEngine).append("'"));
        builder.append(";");
        if (this.isVirtual()) {
            builder.append(" */");
        }
        return builder.build();
    }
}

