/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

public class SearchUtils {
    public static int getOptimalStringAlignmentDistance(String s2, String t2) {
        int i;
        if (s2 == null || t2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s2.length();
        int m4 = t2.length();
        if (n == 0) {
            return m4;
        }
        if (m4 == 0) {
            return n;
        }
        if (n > m4) {
            String tmp = s2;
            s2 = t2;
            t2 = tmp;
            n = m4;
            m4 = t2.length();
        }
        int[] d = new int[n + 1];
        int[] p1 = new int[n + 1];
        int[] p2 = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p1[i] = i;
        }
        for (int j = 1; j <= m4; ++j) {
            char t_j = t2.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                char s_i = s2.charAt(i - 1);
                int cost = s_i == t_j ? 0 : 1;
                int deletion = d[i - 1] + 1;
                int insertion = p1[i] + 1;
                int substitution = p1[i - 1] + cost;
                d[i] = Math.min(Math.min(deletion, insertion), substitution);
                if (i <= 1 || j <= 1 || s_i != t2.charAt(j - 2) || s2.charAt(i - 2) != t_j) continue;
                d[i] = Math.min(d[i], p2[i - 2] + cost);
            }
            int[] _d = p2;
            p2 = p1;
            p1 = d;
            d = _d;
        }
        return p1[n];
    }
}

