/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.api.core.data.geometry.Point;
import java.nio.charset.StandardCharsets;

class GraphBinaryUtils {
    GraphBinaryUtils() {
    }

    static int sizeOfInt() {
        return 4;
    }

    static int sizeOfLong() {
        return 8;
    }

    static int sizeOfDouble() {
        return 8;
    }

    static int sizeOfPoint(Point point) {
        return point.asWellKnownBinary().remaining();
    }

    static int sizeOfString(String s2) {
        return GraphBinaryUtils.sizeOfInt() + s2.getBytes(StandardCharsets.UTF_8).length;
    }

    static int sizeOfDuration() {
        return GraphBinaryUtils.sizeOfInt() + GraphBinaryUtils.sizeOfInt() + GraphBinaryUtils.sizeOfLong();
    }

    static int sizeOfDistance(Point point) {
        return GraphBinaryUtils.sizeOfPoint(point) + GraphBinaryUtils.sizeOfDouble();
    }

    static int sizeOfEditDistance(String s2) {
        return GraphBinaryUtils.sizeOfInt() + GraphBinaryUtils.sizeOfString(s2);
    }
}

