/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.tracker;

import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Request;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface RequestIdGenerator {
    public static final String DEFAULT_PAYLOAD_KEY = "request-id";

    public String getSessionRequestId();

    public String getNodeRequestId(@NonNull Request var1, @NonNull String var2);

    default public String getCustomPayloadKey() {
        return DEFAULT_PAYLOAD_KEY;
    }

    default public Statement<?> getDecoratedStatement(@NonNull Statement<?> statement, @NonNull String requestId) {
        HashMap<String, ByteBuffer> existing = new HashMap<String, ByteBuffer>(statement.getCustomPayload());
        String key = this.getCustomPayloadKey();
        existing.put(key, ByteBuffer.wrap(requestId.getBytes(StandardCharsets.UTF_8)));
        Map<String, ByteBuffer> unmodifiableMap = Collections.unmodifiableMap(existing);
        return statement.setCustomPayload(unmodifiableMap);
    }
}

