/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type;

import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import com.datastax.oss.driver.internal.core.type.DefaultCustomType;
import com.datastax.oss.driver.internal.core.type.DefaultListType;
import com.datastax.oss.driver.internal.core.type.DefaultMapType;
import com.datastax.oss.driver.internal.core.type.DefaultSetType;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import com.datastax.oss.driver.internal.core.type.DefaultVectorType;
import com.datastax.oss.driver.internal.core.type.PrimitiveType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;

public class DataTypes {
    public static final DataType ASCII = new PrimitiveType(1);
    public static final DataType BIGINT = new PrimitiveType(2);
    public static final DataType BLOB = new PrimitiveType(3);
    public static final DataType BOOLEAN = new PrimitiveType(4);
    public static final DataType COUNTER = new PrimitiveType(5);
    public static final DataType DECIMAL = new PrimitiveType(6);
    public static final DataType DOUBLE = new PrimitiveType(7);
    public static final DataType FLOAT = new PrimitiveType(8);
    public static final DataType INT = new PrimitiveType(9);
    public static final DataType TIMESTAMP = new PrimitiveType(11);
    public static final DataType UUID = new PrimitiveType(12);
    public static final DataType VARINT = new PrimitiveType(14);
    public static final DataType TIMEUUID = new PrimitiveType(15);
    public static final DataType INET = new PrimitiveType(16);
    public static final DataType DATE = new PrimitiveType(17);
    public static final DataType TEXT = new PrimitiveType(13);
    public static final DataType TIME = new PrimitiveType(18);
    public static final DataType SMALLINT = new PrimitiveType(19);
    public static final DataType TINYINT = new PrimitiveType(20);
    public static final DataType DURATION = new PrimitiveType(21);
    private static final DataTypeClassNameParser classNameParser = new DataTypeClassNameParser();

    @NonNull
    public static DataType custom(@NonNull String className) {
        if (className.equals("org.apache.cassandra.db.marshal.DurationType")) {
            return DURATION;
        }
        if (className.startsWith("org.apache.cassandra.db.marshal.VectorType")) {
            return classNameParser.parse(className, AttachmentPoint.NONE);
        }
        return new DefaultCustomType(className);
    }

    @NonNull
    public static ListType listOf(@NonNull DataType elementType) {
        return new DefaultListType(elementType, false);
    }

    @NonNull
    public static ListType listOf(@NonNull DataType elementType, boolean frozen) {
        return new DefaultListType(elementType, frozen);
    }

    @NonNull
    public static ListType frozenListOf(@NonNull DataType elementType) {
        return new DefaultListType(elementType, true);
    }

    @NonNull
    public static SetType setOf(@NonNull DataType elementType) {
        return new DefaultSetType(elementType, false);
    }

    @NonNull
    public static SetType setOf(@NonNull DataType elementType, boolean frozen) {
        return new DefaultSetType(elementType, frozen);
    }

    @NonNull
    public static SetType frozenSetOf(@NonNull DataType elementType) {
        return new DefaultSetType(elementType, true);
    }

    @NonNull
    public static MapType mapOf(@NonNull DataType keyType, @NonNull DataType valueType) {
        return new DefaultMapType(keyType, valueType, false);
    }

    @NonNull
    public static MapType mapOf(@NonNull DataType keyType, @NonNull DataType valueType, boolean frozen) {
        return new DefaultMapType(keyType, valueType, frozen);
    }

    @NonNull
    public static MapType frozenMapOf(@NonNull DataType keyType, @NonNull DataType valueType) {
        return new DefaultMapType(keyType, valueType, true);
    }

    @NonNull
    public static TupleType tupleOf(DataType ... componentTypes) {
        return new DefaultTupleType(ImmutableList.copyOf(Arrays.asList(componentTypes)));
    }

    public static VectorType vectorOf(DataType subtype, int dimensions) {
        return new DefaultVectorType(subtype, dimensions);
    }
}

