/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.util.AddressUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactPoints {
    private static final Logger LOG = LoggerFactory.getLogger(ContactPoints.class);

    public static Set<EndPoint> merge(Set<EndPoint> programmaticContactPoints, List<String> configContactPoints, boolean resolve) {
        HashSet<EndPoint> result = Sets.newHashSet(programmaticContactPoints);
        for (String spec : configContactPoints) {
            Set<Object> addresses = Collections.emptySet();
            try {
                addresses = AddressUtils.extract(spec, resolve);
            }
            catch (RuntimeException e) {
                LOG.warn("Ignoring invalid contact point {} ({})", spec, e.getMessage(), e);
            }
            if (addresses.size() > 1) {
                LOG.info("Contact point {} resolves to multiple addresses, will use them all ({})", (Object)spec, (Object)addresses);
            }
            for (InetSocketAddress inetSocketAddress : addresses) {
                DefaultEndPoint endPoint = new DefaultEndPoint(inetSocketAddress);
                boolean wasNew = result.add(endPoint);
                if (wasNew) continue;
                LOG.warn("Duplicate contact point {}", (Object)inetSocketAddress);
            }
        }
        return ImmutableSet.copyOf(result);
    }
}

