/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.HeartbeatException;
import com.datastax.oss.driver.internal.core.channel.ChannelHandlerRequest;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Options;
import com.datastax.oss.protocol.internal.response.Supported;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class HeartbeatHandler
extends IdleStateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatHandler.class);
    private final DriverExecutionProfile config;
    private HeartbeatRequest request;

    HeartbeatHandler(DriverExecutionProfile config) {
        super((int)config.getDuration(DefaultDriverOption.HEARTBEAT_INTERVAL).getSeconds(), 0, 0);
        this.config = config;
    }

    @Override
    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        if (evt.state() == IdleState.READER_IDLE) {
            if (this.request != null) {
                LOG.warn("Not sending heartbeat because a previous one is still in progress. Check that {} is not lower than {}.", (Object)DefaultDriverOption.HEARTBEAT_INTERVAL.getPath(), (Object)DefaultDriverOption.HEARTBEAT_TIMEOUT.getPath());
            } else {
                LOG.debug("Connection was inactive for {} seconds, sending heartbeat", (Object)this.config.getDuration(DefaultDriverOption.HEARTBEAT_INTERVAL).getSeconds());
                long timeoutMillis = this.config.getDuration(DefaultDriverOption.HEARTBEAT_TIMEOUT).toMillis();
                this.request = new HeartbeatRequest(ctx, timeoutMillis);
                this.request.send();
            }
        }
    }

    private class HeartbeatRequest
    extends ChannelHandlerRequest {
        HeartbeatRequest(ChannelHandlerContext ctx, long timeoutMillis) {
            super(ctx, timeoutMillis);
        }

        @Override
        String describe() {
            return "Heartbeat request";
        }

        @Override
        Message getRequest() {
            return Options.INSTANCE;
        }

        @Override
        void onResponse(Message response) {
            if (response instanceof Supported) {
                LOG.debug("{} Heartbeat query succeeded", (Object)this.ctx.channel());
                HeartbeatHandler.this.request = null;
            } else {
                this.failOnUnexpected(response);
            }
        }

        @Override
        void fail(String message, Throwable cause) {
            if (cause instanceof HeartbeatException) {
                return;
            }
            HeartbeatHandler.this.request = null;
            if (message != null) {
                LOG.debug("{} Heartbeat query failed: {}", this.ctx.channel(), message, cause);
            } else {
                LOG.debug("{} Heartbeat query failed", (Object)this.ctx.channel(), (Object)cause);
            }
            this.ctx.fireExceptionCaught(new HeartbeatException(this.ctx.channel().remoteAddress(), message, cause));
        }
    }
}

