/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.nodeset;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.NodeSet;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SingleDcNodeSet
implements NodeSet {
    private final Set<Node> nodes = new CopyOnWriteArraySet<Node>();
    private final String dc;
    private final Set<String> dcs;

    public SingleDcNodeSet(@NonNull String dc) {
        this.dc = dc;
        this.dcs = ImmutableSet.of(dc);
    }

    @Override
    public boolean add(@NonNull Node node) {
        if (Objects.equals(node.getDatacenter(), this.dc)) {
            return this.nodes.add(node);
        }
        return false;
    }

    @Override
    public boolean remove(@NonNull Node node) {
        if (Objects.equals(node.getDatacenter(), this.dc)) {
            return this.nodes.remove(node);
        }
        return false;
    }

    @Override
    @NonNull
    public Set<Node> dc(@Nullable String dc) {
        if (Objects.equals(this.dc, dc)) {
            return this.nodes;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> dcs() {
        return this.dcs;
    }
}

