/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.os;

import com.datastax.oss.driver.internal.core.os.GraalGetpid;
import com.datastax.oss.driver.internal.core.os.Libc;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraalLibc
implements Libc {
    private static final Logger LOG = LoggerFactory.getLogger(GraalLibc.class);
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final String MAC_PLATFORM_STR = "mac".toLowerCase(LOCALE);
    private static final String DARWIN_PLATFORM_STR = "darwin".toLowerCase(LOCALE);
    private static final String LINUX_PLATFORM_STR = "linux".toLowerCase(LOCALE);
    private final boolean available = this.checkAvailability();

    private boolean checkPlatform() {
        String osName = System.getProperty("os.name").split(" ", -1)[0];
        String compareStr = osName.toLowerCase(Locale.ENGLISH);
        return compareStr.startsWith(MAC_PLATFORM_STR) || compareStr.startsWith(DARWIN_PLATFORM_STR) || compareStr.startsWith(LINUX_PLATFORM_STR);
    }

    private boolean checkAvailability() {
        if (!this.checkPlatform()) {
            return false;
        }
        try {
            this.getpidRaw();
        }
        catch (Throwable t2) {
            LOG.debug("Error calling getpid()", t2);
            return false;
        }
        try {
            this.gettimeofdayRaw();
        }
        catch (Throwable t3) {
            LOG.debug("Error calling gettimeofday()", t3);
            return false;
        }
        return true;
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public Optional<Long> gettimeofday() {
        return this.available ? Optional.of(this.gettimeofdayRaw()) : Optional.empty();
    }

    private long gettimeofdayRaw() {
        return Math.round((double)System.nanoTime() / 1000.0);
    }

    @Override
    public Optional<Integer> getpid() {
        return this.available ? Optional.of(this.getpidRaw()) : Optional.empty();
    }

    private int getpidRaw() {
        return GraalGetpid.getpid();
    }
}

