/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.os;

import com.datastax.oss.driver.internal.core.os.Libc;
import java.util.Optional;
import java.util.function.Consumer;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.Timeval;
import jnr.posix.util.DefaultPOSIXHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnrLibc
implements Libc {
    private static final Logger LOG = LoggerFactory.getLogger(JnrLibc.class);
    private final Optional<POSIX> posix = this.loadPosix();

    @Override
    public Optional<Long> gettimeofday() {
        return this.posix.flatMap(this::gettimeofdayImpl);
    }

    @Override
    public Optional<Integer> getpid() {
        return this.posix.map(POSIX::getpid);
    }

    @Override
    public boolean available() {
        return this.posix.isPresent();
    }

    private Optional<POSIX> loadPosix() {
        try {
            return Optional.of(POSIXFactory.getPOSIX(new DefaultPOSIXHandler(), true)).flatMap(p -> this.catchAll((POSIX)p, posix -> posix.getpid(), "Error calling getpid()")).flatMap(p -> this.catchAll((POSIX)p, this::gettimeofdayImpl, "Error calling gettimeofday()"));
        }
        catch (Throwable t2) {
            LOG.debug("Error loading POSIX", t2);
            return Optional.empty();
        }
    }

    private Optional<POSIX> catchAll(POSIX posix, Consumer<POSIX> fn, String debugStr) {
        try {
            fn.accept(posix);
            return Optional.of(posix);
        }
        catch (Throwable t2) {
            LOG.debug(debugStr, t2);
            return Optional.empty();
        }
    }

    private Optional<Long> gettimeofdayImpl(POSIX posix) {
        Timeval tv = posix.allocateTimeval();
        int rv = posix.gettimeofday(tv);
        if (rv != 0) {
            LOG.debug("Expected 0 return value from gettimeofday(), observed " + rv);
            return Optional.empty();
        }
        return Optional.of(tv.sec() * 1000000L + tv.usec());
    }
}

