/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.os;

import com.datastax.oss.driver.internal.core.os.CpuInfo;
import com.datastax.oss.driver.internal.core.os.EmptyLibc;
import com.datastax.oss.driver.internal.core.os.GraalLibc;
import com.datastax.oss.driver.internal.core.os.JnrLibc;
import com.datastax.oss.driver.internal.core.os.Libc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Native {
    private static final Logger LOG = LoggerFactory.getLogger(Native.class);
    private static final Libc LIBC = new LibcLoader().load();
    private static final CpuInfo.Cpu CPU = CpuInfo.determineCpu();
    private static final String NATIVE_CALL_ERR_MSG = "Native call failed or was not available";

    public static boolean isCurrentTimeMicrosAvailable() {
        return LIBC.available();
    }

    public static long currentTimeMicros() {
        return LIBC.gettimeofday().orElseThrow(() -> new IllegalStateException(NATIVE_CALL_ERR_MSG));
    }

    public static boolean isGetProcessIdAvailable() {
        return LIBC.available();
    }

    public static int getProcessId() {
        return LIBC.getpid().orElseThrow(() -> new IllegalStateException(NATIVE_CALL_ERR_MSG));
    }

    public static String getCpu() {
        return CPU.toString();
    }

    private static class LibcLoader {
        private static final String GRAAL_STATUS_PROP = "org.graalvm.nativeimage.imagecode";
        private static final String GRAAL_BUILDTIME_STATUS = "buildtime";
        private static final String GRAAL_RUNTIME_STATUS = "runtime";

        private LibcLoader() {
        }

        public Libc load() {
            try {
                if (this.isGraal()) {
                    LOG.info("Using Graal-specific native functions");
                    return new GraalLibc();
                }
                return new JnrLibc();
            }
            catch (Throwable t2) {
                LOG.info("Unable to load JNR native implementation. This could be normal if JNR is excluded from the classpath", t2);
                return new EmptyLibc();
            }
        }

        private boolean isGraal() {
            String val = System.getProperty(GRAAL_STATUS_PROP);
            return val != null && (val.equals(GRAAL_RUNTIME_STATUS) || val.equalsIgnoreCase(GRAAL_BUILDTIME_STATUS));
        }
    }
}

