/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;

public class AddressUtils {
    public static Set<InetSocketAddress> extract(String address, boolean resolve) {
        InetAddress[] inetAddresses;
        int port;
        int separator = address.lastIndexOf(58);
        if (separator < 0) {
            throw new IllegalArgumentException("expecting format host:port");
        }
        String host = address.substring(0, separator);
        String portString = address.substring(separator + 1);
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("expecting port to be a number, got " + portString, e);
        }
        if (!resolve) {
            return ImmutableSet.of(InetSocketAddress.createUnresolved(host, port));
        }
        try {
            inetAddresses = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        HashSet<InetSocketAddress> result = new HashSet<InetSocketAddress>();
        for (InetAddress inetAddress : inetAddresses) {
            result.add(new InetSocketAddress(inetAddress, port));
        }
        return result;
    }
}

