/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafna.raspberry.grovepi;

import com.github.yafna.raspberry.grovepi.GroveAnalogInListener;
import com.github.yafna.raspberry.grovepi.GrovePi;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GroveAnalogIn
implements Runnable {
    private final GrovePi grovePi;
    private final int pin;
    private GroveAnalogInListener listener;
    private final int bufferSize;

    public GroveAnalogIn(GrovePi grovePi, int pin, int bufferSize) throws IOException {
        this.grovePi = grovePi;
        this.pin = pin;
        grovePi.execVoid(io -> io.write(5, 0, pin, 0));
        this.bufferSize = bufferSize;
    }

    @Override
    public void run() {
        try {
            this.get();
        }
        catch (IOException ex) {
            Logger.getLogger("GrovePi").log(Level.SEVERE, null, ex);
        }
    }

    public byte[] get() throws IOException {
        byte[] value = this.grovePi.exec(io -> {
            io.write(3, this.pin, 0, 0);
            io.sleep(100L);
            return io.read(new byte[this.bufferSize]);
        });
        if (this.listener != null) {
            this.listener.onChange(value);
        }
        return value;
    }

    public void setListener(GroveAnalogInListener listener) {
        this.listener = listener;
    }
}

