/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafna.raspberry.grovepi;

import com.github.yafna.raspberry.grovepi.GroveDigitalInListener;
import com.github.yafna.raspberry.grovepi.GrovePi;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GroveDigitalIn
implements Runnable {
    private final GrovePi grovePi;
    private final int pin;
    private boolean status = false;
    private GroveDigitalInListener listener;

    public GroveDigitalIn(GrovePi grovePi, int pin) throws IOException {
        this.grovePi = grovePi;
        this.pin = pin;
        grovePi.execVoid(io -> io.write(5, pin, 0, 0));
    }

    public boolean get() throws IOException, InterruptedException {
        boolean st = this.grovePi.exec(io -> {
            io.write(1, this.pin, 0, 0);
            io.sleep(100L);
            return io.read() == 1;
        });
        if (this.listener != null && this.status != st) {
            this.listener.onChange(this.status, st);
        }
        this.status = st;
        return st;
    }

    public void setListener(GroveDigitalInListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        try {
            this.get();
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger("GrovePi").log(Level.SEVERE, null, ex);
        }
    }
}

