/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafna.raspberry.grovepi.devices;

import com.github.yafna.raspberry.grovepi.GroveDigitalPin;
import com.github.yafna.raspberry.grovepi.GrovePi;
import java.io.IOException;

@GroveDigitalPin
public class GroveLed {
    public static int MAX_BRIGTHNESS = 255;
    private final GrovePi grovePi;
    private final int pin;

    public GroveLed(GrovePi grovePi, int pin) throws IOException {
        this.grovePi = grovePi;
        this.pin = pin;
        grovePi.execVoid(io -> io.write(5, pin, 1, 0));
        this.set(false);
    }

    public final void set(boolean value) throws IOException {
        int val = value ? 1 : 0;
        this.grovePi.execVoid(io -> io.write(2, this.pin, val, 0));
    }

    public final void set(int value) throws IOException {
        int val = value > 255 ? 255 : (value < 0 ? 0 : value);
        this.grovePi.execVoid(io -> io.write(4, this.pin, val, 0));
    }
}

