/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafna.raspberry.grovepi.devices;

import com.github.yafna.raspberry.grovepi.GroveI2CPin;
import com.github.yafna.raspberry.grovepi.GrovePiSequenceVoid;
import java.io.IOException;

@GroveI2CPin
public abstract class GroveRgbLcd
implements AutoCloseable {
    public static final int DISPLAY_RGB_ADDR = 98;
    public static final int DISPLAY_TEXT_ADDR = 62;
    private static final int LCD_COMMAND = 128;
    private static final int LCD_WRITECHAR = 64;
    private static final int LCD_CMD_CLEARDISPLAY = 1;
    private static final int LCD_CMD_NEWLINE = 192;
    private static final int REG_RED = 4;
    private static final int REG_GREEN = 3;
    private static final int REG_BLUE = 2;

    protected void init() throws IOException {
        this.execRGB(io -> {
            io.write(0, 0);
            io.write(1, 0);
            io.write(8, 170);
        });
        this.execTEXT(io -> {
            io.write(128, 12);
            io.write(128, 40);
            io.write(128, 1);
            io.sleep(50L);
        });
    }

    public void setRGB(int r, int g2, int b) throws IOException {
        this.execRGB(io -> {
            io.write(4, r);
            io.write(3, g2);
            io.write(2, b);
            io.sleep(50L);
        });
    }

    public void setText(String text) throws IOException {
        this.execTEXT(io -> {
            io.write(128, 1);
            io.sleep(50L);
            int count = 0;
            int row = 0;
            for (int n : text.toCharArray()) {
                if (n == 10 || count == 16) {
                    count = 0;
                    if (++row == 2) break;
                    io.write(128, 192);
                    if (n == 10) continue;
                }
                ++count;
                io.write(64, n);
            }
            io.sleep(100L);
        });
    }

    public abstract void execRGB(GrovePiSequenceVoid<?> var1) throws IOException;

    public abstract void execTEXT(GrovePiSequenceVoid<?> var1) throws IOException;

    @Override
    public abstract void close();
}

