/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafna.raspberry.grovepi.devices;

import com.github.yafna.raspberry.grovepi.GroveAnalogPin;
import com.github.yafna.raspberry.grovepi.GrovePi;
import com.github.yafna.raspberry.grovepi.GroveUtil;
import com.github.yafna.raspberry.grovepi.devices.GroveAnalogInputDevice;
import com.github.yafna.raspberry.grovepi.devices.GroveRotaryValue;
import java.io.IOException;

@GroveAnalogPin
public class GroveRotarySensor
extends GroveAnalogInputDevice<GroveRotaryValue> {
    public static final double ADC_REF = 5.0;
    public static final double GROVE_VCC = 5.0;
    public static final double FULL_ANGLE = 300.0;

    public GroveRotarySensor(GrovePi grovePi, int pin) throws IOException {
        super(grovePi.getAnalogIn(pin, 4));
    }

    @Override
    public GroveRotaryValue get(byte[] b) {
        int[] v = GroveUtil.unsign(b);
        double sensor_value = v[1] * 256 + v[2];
        double voltage = sensor_value * 5.0 / 1023.0;
        double degrees2 = voltage * 300.0 / 5.0;
        return new GroveRotaryValue(sensor_value, voltage, degrees2);
    }
}

