/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafna.raspberry.grovepi.devices;

import com.github.yafna.raspberry.grovepi.GroveDigitalPin;
import com.github.yafna.raspberry.grovepi.GrovePi;
import com.github.yafna.raspberry.grovepi.devices.GroveTemperatureAndHumidityValue;
import java.io.IOException;
import java.nio.ByteBuffer;

@GroveDigitalPin
public class GroveTemperatureAndHumiditySensor {
    private final GrovePi grovePi;
    private final int pin;
    private final Type dhtType;

    public GroveTemperatureAndHumiditySensor(GrovePi grovePi, int pin, Type dhtType) {
        this.grovePi = grovePi;
        this.pin = pin;
        this.dhtType = dhtType;
    }

    public GroveTemperatureAndHumidityValue get() throws IOException {
        byte[] data = this.grovePi.exec(io -> {
            io.write(40, this.pin, this.dhtType.moduleType, 0);
            io.sleep(600L);
            return io.read(new byte[9]);
        });
        double temp = ByteBuffer.wrap(new byte[]{data[4], data[3], data[2], data[1]}).getFloat();
        double humid = ByteBuffer.wrap(new byte[]{data[8], data[7], data[6], data[5]}).getFloat();
        return new GroveTemperatureAndHumidityValue(temp, humid);
    }

    public static enum Type {
        DHT11(0),
        DHT22(1),
        DHT21(2),
        AM2301(3);

        private final int moduleType;

        private Type(int moduleType) {
            this.moduleType = moduleType;
        }

        public int getModuleType() {
            return this.moduleType;
        }
    }
}

