/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafna.raspberry.grovepi.pi4j;

import com.github.yafna.raspberry.grovepi.GrovePi;
import com.github.yafna.raspberry.grovepi.GrovePiSequence;
import com.github.yafna.raspberry.grovepi.GrovePiSequenceVoid;
import com.github.yafna.raspberry.grovepi.pi4j.IO;
import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import java.io.IOException;

public class GrovePi4J
implements GrovePi {
    public static final String UNIQUE_ID = "Grove-Pi-BUS-1";
    public static final int I2C_BUS = 1;
    public static final int GROVEPI_ADDRESS = 4;
    private I2C device;
    private Context pi4j;

    public GrovePi4J(Context pi4j) throws IOException {
        this.pi4j = pi4j;
        I2CConfig config = (I2CConfig)((I2CConfigBuilder)((I2CConfigBuilder)I2C.newConfigBuilder(pi4j).id(UNIQUE_ID)).name("My I2C Bus")).bus(1).device(4).build();
        this.device = pi4j.create(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T exec(GrovePiSequence<T> sequence) throws IOException {
        GrovePi4J grovePi4J = this;
        synchronized (grovePi4J) {
            return sequence.execute(new IO(this.device));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execVoid(GrovePiSequenceVoid<?> sequence) throws IOException {
        GrovePi4J grovePi4J = this;
        synchronized (grovePi4J) {
            sequence.execute(new IO(this.device));
        }
    }

    @Override
    public void close() {
        this.device.close();
    }
}

