/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.base.I2CDevice;
import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class Ads1115
extends I2CDevice {
    private static final int CONVERSION_REGISTER = 0;
    private static final int CONFIG_REGISTER = 1;
    private static final int LO_THRESH_REGISTER = 2;
    private static final int HI_THRESH_REGISTER = 3;
    private final Context pi4j;
    private final GAIN pga;
    private final DataRate dataRate;
    private final Map<Channel, Double> oldVoltages = new HashMap<Channel, Double>();
    private final Map<Channel, Consumer<Double>> channelsInUse = new HashMap<Channel, Consumer<Double>>();
    private final Map<Channel, RawValueRange> valueRanges = new HashMap<Channel, RawValueRange>();
    private boolean continuousReadingActive;
    private final int configRegisterTemplate;

    public Ads1115(Context pi4j) {
        this(pi4j, ADDRESS.GND, GAIN.GAIN_6_144V);
    }

    public Ads1115(Context pi4j, ADDRESS device, GAIN gain) {
        super(pi4j, device.address, "ADS1115");
        this.pi4j = pi4j;
        this.pga = gain;
        this.dataRate = DataRate.SPS_128;
        int operationalStatus = OperationalStatus.WRITE_START.getOperationalStatus();
        int compMode = COMP_MODE.TRAD_COMP.getCompMode();
        int compPol = COMP_POL.ACTIVE_LOW.getCompPol();
        int latching = COMP_LAT.NON_LATCH.getLatching();
        int compQue = COMP_QUE.DISABLE_COMP.getCompQue();
        this.configRegisterTemplate = operationalStatus | this.pga.gain | this.dataRate.getConf() | compMode | compPol | latching | compQue;
    }

    Context getPi4j() {
        return this.pi4j;
    }

    @Override
    protected void init(I2C i2c) {
    }

    public void onValueChange(Channel channel, Consumer<Double> onChange) {
        if (onChange != null) {
            if (this.continuousReadingActive) {
                throw new IllegalStateException("Can't add a new onValueChange while continuous reading is active");
            }
            this.channelsInUse.put(channel, onChange);
        } else {
            this.channelsInUse.remove((Object)channel);
        }
    }

    public double maxRawValue(Channel channel) {
        return this.getRange((Channel)channel).maxRawValue;
    }

    public double minRawValue(Channel channel) {
        return this.getRange((Channel)channel).minRawValue;
    }

    public double readValue(Channel channel) {
        if (this.continuousReadingActive) {
            throw new IllegalStateException("Continuous measuring active, can't read a single value");
        }
        double voltage = this.readSingleValue(channel);
        this.logDebug("current value of channel %s: %.2f", new Object[]{channel, voltage});
        return voltage;
    }

    public void startContinuousReading(double threshold) {
        if (this.continuousReadingActive) {
            throw new IllegalStateException("continuous reading already active");
        }
        this.continuousReadingActive = true;
        this.readAllChannels(threshold);
        this.logDebug("Start continuous reading", new Object[0]);
    }

    public void stopContinuousReading() {
        this.continuousReadingActive = false;
        this.logDebug("Continuous reading stopped", new Object[0]);
    }

    @Override
    public void reset() {
        this.stopContinuousReading();
        this.delay(Duration.ofMillis((long)this.channelsInUse.size() * 16L));
        this.channelsInUse.clear();
        this.oldVoltages.clear();
    }

    public void resetChannel(Channel channel) {
        this.channelsInUse.remove((Object)channel);
        this.oldVoltages.remove((Object)channel);
    }

    private double readSingleValue(Channel channel) {
        MultiplexerConfig mpc = switch (channel.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> MultiplexerConfig.AIN0_GND;
            case 1 -> MultiplexerConfig.AIN1_GND;
            case 2 -> MultiplexerConfig.AIN2_GND;
            case 3 -> MultiplexerConfig.AIN3_GND;
        };
        this.writeRegister(1, this.configRegisterTemplate | mpc.getMux() | OperationMode.SINGLE.getMode());
        this.delay(Duration.ofMillis((long)(2000.0 / (double)this.dataRate.getSpS())));
        int registeredValue = this.readRegister(0);
        double voltage = this.pga.gainPerBit * (double)registeredValue;
        RawValueRange range = this.getRange(channel);
        range.maxRawValue = Math.max(range.maxRawValue, voltage);
        range.minRawValue = Math.min(range.minRawValue, voltage);
        return voltage;
    }

    private void readAllChannels(double threshold) {
        this.logDebug("Start continuous reading", new Object[0]);
        long readFrequency = (long)(this.channelsInUse.size() * 16) * 1000000L;
        new Thread(() -> {
            while (this.continuousReadingActive) {
                long startTime = System.nanoTime();
                this.channelsInUse.forEach((channel, onValueChange) -> {
                    if (this.continuousReadingActive) {
                        double newVoltage = this.readSingleValue((Channel)((Object)((Object)channel)));
                        this.logDebug("Current value of channel %s: %d", channel, newVoltage);
                        double oldVoltage = this.getOldVoltage((Channel)((Object)((Object)channel)));
                        if (Math.abs(oldVoltage - newVoltage) >= threshold) {
                            this.logDebug("New value change triggered on channel %s, old value: %f , new value: %f", channel, oldVoltage, newVoltage);
                            this.oldVoltages.put((Channel)((Object)((Object)channel)), newVoltage);
                            onValueChange.accept(newVoltage);
                        }
                    }
                });
                long elapsedNanos = System.nanoTime() - startTime;
                long restDelay = elapsedNanos - readFrequency;
                this.delay(Duration.ofMillis((restDelay > 0L ? restDelay : 0L) / 1000000L));
            }
        }).start();
    }

    private double getOldVoltage(Channel channel) {
        return this.oldVoltages.computeIfAbsent(channel, c -> -10.0);
    }

    private RawValueRange getRange(Channel channel) {
        return this.valueRanges.computeIfAbsent(channel, c -> new RawValueRange());
    }

    public static enum ADDRESS {
        GND(72),
        VDD(73),
        SDA(74),
        SCL(75);

        private final int address;

        private ADDRESS(int address) {
            this.address = address;
        }

        public int getAddress() {
            return this.address;
        }
    }

    public static enum GAIN {
        GAIN_6_144V(PGA.FSR_6_144.pga, 1.875E-4),
        GAIN_4_096V(PGA.FSR_4_096.pga, 1.25E-4),
        GAIN_2_048V(PGA.FSR_2_048.pga, 6.25E-5),
        GAIN_1_024V(PGA.FSR_1_024.pga, 3.125E-5),
        GAIN_0_512V(PGA.FSR_0_512.pga, 1.5625E-5),
        GAIN_0_256V(PGA.FSR_0_256.pga, 7.8125E-6);

        private final int gain;
        private final double gainPerBit;

        private GAIN(int gain, double gainPerBit) {
            this.gain = gain;
            this.gainPerBit = gainPerBit;
        }

        public int gain() {
            return this.gain;
        }

        public double gainPerBit() {
            return this.gainPerBit;
        }
    }

    public static enum DataRate {
        SPS_8(0, 8),
        SPS_16(32, 16),
        SPS_32(64, 32),
        SPS_64(96, 64),
        SPS_128(128, 128),
        SPS_250(160, 250),
        SPS_475(192, 475),
        SPS_860(224, 860),
        CLR_OTHER_CONF_PARAM(224, 0),
        CLR_CURRENT_CONF_PARAM(65311, 0);

        private final int conf;
        private final int sps;

        private DataRate(int conf, int sps) {
            this.conf = conf;
            this.sps = sps;
        }

        public int getSpS() {
            return this.sps;
        }

        public int getConf() {
            return this.conf;
        }
    }

    public static enum OperationalStatus {
        WRITE_START(32768),
        READ_CONV(0),
        READ_NO_CONV(32768),
        CLR_OTHER_CONF_PARAM(32768),
        CLR_CURRENT_CONF_PARAM(Short.MAX_VALUE);

        private final int os;

        private OperationalStatus(int os) {
            this.os = os;
        }

        public int getOperationalStatus() {
            return this.os;
        }
    }

    public static enum COMP_MODE {
        TRAD_COMP(0),
        WINDOW_COMP(16),
        CLR_OTHER_CONF_PARAM(16),
        CLR_CURRENT_CONF_PARAM(65519);

        private final int compMode;

        private COMP_MODE(int compMOde) {
            this.compMode = compMOde;
        }

        public int getCompMode() {
            return this.compMode;
        }
    }

    public static enum COMP_POL {
        ACTIVE_LOW(0),
        ACTIVE_HIGH(8),
        CLR_OTHER_CONF_PARAM(8),
        CLR_CURRENT_CONF_PARAM(65527);

        private final int compPol;

        private COMP_POL(int compPol) {
            this.compPol = compPol;
        }

        public int getCompPol() {
            return this.compPol;
        }
    }

    public static enum COMP_LAT {
        NON_LATCH(0),
        DO_LATCH(4),
        CLR_OTHER_CONF_PARAM(4),
        CLR_CURRENT_CONF_PARAM(65531);

        private final int latching;

        private COMP_LAT(int compLat) {
            this.latching = compLat;
        }

        public int getLatching() {
            return this.latching;
        }
    }

    public static enum COMP_QUE {
        ASSERT_ONE(0),
        ASSERT_TWO(1),
        ASSERT_FOUR(2),
        DISABLE_COMP(3),
        CLR_OTHER_CONF_PARAM(3),
        CLR_CURRENT_CONF_PARAM(65532);

        private final int compQue;

        private COMP_QUE(int compQue) {
            this.compQue = compQue;
        }

        public int getCompQue() {
            return this.compQue;
        }
    }

    public static enum Channel {
        A0,
        A1,
        A2,
        A3;

    }

    private static class RawValueRange {
        double minRawValue = 0.1;
        double maxRawValue = 3.2;

        private RawValueRange() {
        }
    }

    public static enum MultiplexerConfig {
        AIN0_AIN1(0),
        AIN0_AIN3(4096),
        AIN1_AIN3(8192),
        AIN2_AIN3(12288),
        AIN0_GND(16384),
        AIN1_GND(20480),
        AIN2_GND(24576),
        AIN3_GND(28672),
        CLR_OTHER_CONF_PARAM(28672),
        CLR_CURRENT_CONF_PARAM(36863);

        private final int mux;

        private MultiplexerConfig(int mux) {
            this.mux = mux;
        }

        public int getMux() {
            return this.mux;
        }
    }

    public static enum OperationMode {
        CONTINUOUS(0),
        SINGLE(256),
        CLR_OTHER_CONF_PARAM(256),
        CLR_CURRENT_CONF_PARAM(65279);

        private final int mode;

        private OperationMode(int mode) {
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }
    }

    public static enum PGA {
        FSR_6_144(0),
        FSR_4_096(512),
        FSR_2_048(1024),
        FSR_1_024(1536),
        FSR_0_512(2048),
        FSR_0_256(2560),
        CLR_OTHER_CONF_PARAM(3584),
        CLR_CURRENT_CONF_PARAM(61951);

        private final int pga;

        private PGA(int pag) {
            this.pga = pag;
        }

        public int getPga() {
            return this.pga;
        }
    }
}

