/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.Ads1115;
import com.pi4j.catalog.components.Potentiometer;
import com.pi4j.catalog.components.SimpleButton;
import com.pi4j.catalog.components.base.Component;
import com.pi4j.catalog.components.base.PIN;
import java.time.Duration;

public class JoystickAnalog
extends Component {
    private final Ads1115 ads1115;
    private final Potentiometer xAxis;
    private final Potentiometer yAxis;
    private final SimpleButton push;
    private final double normThreshold;
    private double xActualValue;
    private double yActualValue;
    private double xLastNotifiedValue = 999.0;
    private double yLastNotifiedValue = 999.0;

    public JoystickAnalog(Ads1115 ads1115, Ads1115.Channel channelXAxis, Ads1115.Channel channelYAxis, PIN pin, boolean inverted) {
        this(ads1115, new Potentiometer(ads1115, channelXAxis, Potentiometer.Range.MINUS_ONE_TO_ONE), new Potentiometer(ads1115, channelYAxis, Potentiometer.Range.MINUS_ONE_TO_ONE), 0.05, pin != null ? new SimpleButton(ads1115.getPi4j(), pin, inverted) : null);
    }

    JoystickAnalog(Ads1115 ads1115, Potentiometer potentiometerX, Potentiometer potentiometerY, double normThreshold, SimpleButton push) {
        this.ads1115 = ads1115;
        this.xAxis = potentiometerX;
        this.yAxis = potentiometerY;
        this.push = push;
        this.normThreshold = normThreshold;
    }

    public void onMove(PositionConsumer onMove, Runnable onCenter) {
        this.xAxis.onNormalizedValueChange(xPos -> {
            this.xActualValue = xPos;
            this.notifyIfNeeded(onMove, onCenter);
        });
        this.yAxis.onNormalizedValueChange(yPos -> {
            this.yActualValue = -yPos.doubleValue();
            this.notifyIfNeeded(onMove, onCenter);
        });
    }

    private synchronized void notifyIfNeeded(PositionConsumer onMove, Runnable onCenter) {
        double homeArea = 0.1;
        if (Math.abs(this.xActualValue) <= 0.1 && Math.abs(this.yActualValue) <= 0.1) {
            this.xLastNotifiedValue = this.xActualValue;
            this.yLastNotifiedValue = this.yActualValue;
            if (onCenter != null) {
                onCenter.run();
            }
        } else {
            double distance = Math.sqrt(Math.pow(this.xActualValue - this.xLastNotifiedValue, 2.0) + Math.pow(this.yActualValue - this.yLastNotifiedValue, 2.0));
            if (distance > this.normThreshold) {
                this.xLastNotifiedValue = this.xActualValue;
                this.yLastNotifiedValue = this.yActualValue;
                if (onMove != null) {
                    onMove.accept(this.xLastNotifiedValue, this.yLastNotifiedValue);
                }
            }
        }
    }

    public void onDown(Runnable task) {
        if (this.push == null) {
            throw new IllegalStateException("no button set, you can't register an event");
        }
        this.push.onDown(task);
    }

    public void onUp(Runnable task) {
        if (this.push == null) {
            throw new IllegalStateException("no button set, you can't register an event");
        }
        this.push.onUp(task);
    }

    public void whilePressed(Runnable task, Duration whilePressedDelay) {
        if (this.push == null) {
            throw new IllegalStateException("no button set, you can't register an event");
        }
        this.push.whilePressed(task, whilePressedDelay);
    }

    @Override
    public void reset() {
        this.ads1115.stopContinuousReading();
        this.xAxis.reset();
        this.yAxis.reset();
        this.push.reset();
    }

    @FunctionalInterface
    public static interface PositionConsumer {
        public void accept(double var1, double var3);
    }
}

