/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.SimpleButton;
import com.pi4j.catalog.components.SimpleLed;
import com.pi4j.catalog.components.base.Component;
import com.pi4j.catalog.components.base.PIN;
import com.pi4j.context.Context;
import com.pi4j.plugin.mock.provider.gpio.digital.MockDigitalInput;
import com.pi4j.plugin.mock.provider.gpio.digital.MockDigitalOutput;
import java.time.Duration;

public class LedButton
extends Component {
    private final SimpleButton button;
    private final SimpleLed led;

    public LedButton(Context pi4j, PIN buttonAddress, Boolean inverted, PIN ledAddress) {
        this(pi4j, buttonAddress, inverted, ledAddress, 10000L);
    }

    public LedButton(Context pi4j, PIN buttonAddress, boolean inverted, PIN ledAddress, long debounce) {
        this(new SimpleButton(pi4j, buttonAddress, inverted, debounce), new SimpleLed(pi4j, ledAddress));
    }

    public LedButton(SimpleButton button, SimpleLed led) {
        this.button = button;
        this.led = led;
    }

    public void ledOn() {
        this.led.on();
    }

    public void ledOff() {
        this.led.off();
    }

    public boolean toggleLed() {
        return this.led.toggle();
    }

    public boolean isDown() {
        return this.button.isDown();
    }

    public boolean isUp() {
        return this.button.isUp();
    }

    public void onDown(Runnable task) {
        this.button.onDown(task);
    }

    public void onUp(Runnable task) {
        this.button.onUp(task);
    }

    public void whilePressed(Runnable task, Duration delay) {
        this.button.whilePressed(task, delay);
    }

    @Override
    public void reset() {
        this.button.reset();
        this.led.reset();
    }

    public MockDigitalOutput mockLed() {
        return this.led.mock();
    }

    public MockDigitalInput mockButton() {
        return this.button.mock();
    }
}

