/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.LedStrip;
import com.pi4j.catalog.components.base.Component;
import com.pi4j.context.Context;
import java.time.Duration;

public class LedMatrix
extends Component {
    private final LedStrip ledStrip;
    private final int rows;
    private final int columns;

    public LedMatrix(Context pi4j, int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.ledStrip = new LedStrip(pi4j, rows * columns);
    }

    @Override
    public void reset() {
        super.reset();
        this.ledStrip.reset();
    }

    public int getPixelColor(int row, int column) {
        return this.ledStrip.getPixelColor(this.positionOnStrip(row, column));
    }

    public void setPixelColor(int row, int column, int color) {
        this.ledStrip.setPixelColor(this.positionOnStrip(row, column), color);
    }

    public void setRowColor(int row, int color) {
        for (int i = row * this.columns; i < row * this.columns + this.columns; ++i) {
            this.ledStrip.setPixelColor(i, color);
        }
    }

    public void setColumnColor(int column, int color) {
        for (int i = 0; i < this.rows; ++i) {
            this.ledStrip.setPixelColor(this.positionOnStrip(i, column), color);
        }
    }

    public void setMatrixColor(int color) {
        this.ledStrip.setStripColor(color);
    }

    public void render(Duration duration) {
        this.ledStrip.render(duration);
    }

    public void allOff() {
        this.ledStrip.allOff();
    }

    public void setMaxBrightness(double brightness) {
        this.ledStrip.setMaxBrightness(brightness);
    }

    private int positionOnStrip(int row, int col) {
        boolean even = row % 2 == 0;
        int pos = even ? row * this.columns + col : row * this.columns + (this.columns - 1 - col);
        System.out.printf("row %d, col %d, even %b, pos %d %n", row, col, even, pos);
        return pos;
    }
}

