/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.base.SpiDevice;
import com.pi4j.context.Context;
import com.pi4j.io.spi.Spi;
import com.pi4j.io.spi.SpiBus;
import com.pi4j.io.spi.SpiConfig;
import com.pi4j.io.spi.SpiConfigBuilder;
import java.time.Duration;
import java.util.Arrays;

public class LedStrip
extends SpiDevice {
    private static final int DEFAULT_SPI_CHANNEL = 0;
    private static final float DEFAULT_BRIGHTNESS = 0.2f;
    private static final int DEFAULT_FREQUENCY_PI3 = 800000;
    private static final int DEFAULT_FREQUENCY_PI4 = 500000;
    private static final byte Bit_0 = -64;
    private static final byte Bit_1 = -8;
    private static final byte Bit_Reset = 0;
    private final int numberOfLEDs;
    private final int[] ledColors;
    private double maxBrightness;

    public LedStrip(Context pi4j, int numberOfLEDs) {
        this(pi4j, numberOfLEDs, 0.2f, 0);
    }

    public LedStrip(Context pi4j, int numberOfLEDs, double maxBrightness, int channel) {
        super(pi4j, (SpiConfig)((SpiConfigBuilder)((SpiConfigBuilder)((SpiConfigBuilder)Spi.newConfigBuilder(pi4j).id("SPI-" + channel)).bus(SpiBus.BUS_1).name("LED Strip")).address(channel)).baud(4000000).build());
        if (numberOfLEDs < 1 || maxBrightness < 0.0 || maxBrightness > 1.0 || channel < 0 || channel > 1) {
            throw new IllegalArgumentException("Illegal Constructor");
        }
        this.numberOfLEDs = numberOfLEDs;
        this.ledColors = new int[numberOfLEDs];
        this.setMaxBrightness(0.01);
        this.blink(16753920, Duration.ofMillis(200L), 2);
        this.setMaxBrightness(maxBrightness);
        this.logDebug("LED strip with %d LEDs", numberOfLEDs);
    }

    public void blink(int color, Duration pulse, int times) {
        this.alternate(color, 0, pulse, times);
    }

    public void alternate(int firstColor, int secondColor, Duration pulse, int times) {
        for (int i = 0; i < times; ++i) {
            this.setStripColor(firstColor);
            this.render(pulse);
            this.setStripColor(secondColor);
            this.render(pulse);
        }
    }

    @Override
    public void reset() {
        this.allOff();
        this.render(Duration.ZERO);
        super.reset();
    }

    public int getNumPixels() {
        return this.numberOfLEDs;
    }

    public int getPixelColor(int pixel) {
        return this.ledColors[pixel];
    }

    public void setPixelColor(int pixel, int color) {
        this.ledColors[pixel] = LedColor.scaleColorToBrightness(color, this.maxBrightness);
    }

    public void setStripColor(int color) {
        int dimmedColor = LedColor.scaleColorToBrightness(color, this.maxBrightness);
        Arrays.fill(this.ledColors, dimmedColor);
    }

    public void allOff() {
        Arrays.fill(this.ledColors, 0);
    }

    public double getMaxBrightness() {
        return this.maxBrightness;
    }

    public void setMaxBrightness(double maxBrightness) {
        if (maxBrightness < 0.0 || maxBrightness > 1.0) {
            throw new IllegalArgumentException("Illegal Brightness Value. Must be between 0 and 1");
        }
        this.maxBrightness = maxBrightness;
    }

    public void render(Duration idlePeriod) {
        int counter = 1;
        int numberOfBitsForLeds = 24 * this.numberOfLEDs;
        byte[] pixelRaw = new byte[numberOfBitsForLeds + 2];
        for (int i = 0; i < this.numberOfLEDs; ++i) {
            int j;
            for (j = 15; j >= 8; --j) {
                pixelRaw[counter++] = (this.ledColors[i] >> j & 1) == 1 ? -8 : -64;
            }
            for (j = 23; j >= 16; --j) {
                pixelRaw[counter++] = (this.ledColors[i] >> j & 1) == 1 ? -8 : -64;
            }
            for (j = 7; j >= 0; --j) {
                pixelRaw[counter++] = (this.ledColors[i] >> j & 1) == 1 ? -8 : -64;
            }
        }
        pixelRaw[0] = 0;
        pixelRaw[pixelRaw.length - 1] = 0;
        this.sendToSerialDevice(pixelRaw);
        this.logDebug("Finished rendering of LED strip", new Object[0]);
        this.delay(idlePeriod);
    }

    public static class LedColor {
        public static final int WHITE = 0xFFFFFF;
        public static final int RED = 0xFF0000;
        public static final int ORANGE = 16753920;
        public static final int YELLOW = 0xFFFF00;
        public static final int GREEN = 65280;
        public static final int LIGHT_BLUE = 11393254;
        public static final int BLUE = 255;
        public static final int PURPLE = 0x800080;
        public static final int PINK = 16761035;
        private static final int WHITE_MASK = 0xFFFFFF;
        private static final int RED_MASK = 0xFF0000;
        private static final int GREEN_MASK = 65280;
        private static final int BLUE_MASK = 255;
        private static final int RED_OFF_MASK = 65535;
        private static final int GREEN_OFF_MASK = 0xFF00FF;
        private static final int BLUE_OFF_MASK = 0xFFFF00;
        public static final int Color_COMPONENT_MAX = 255;

        public static int wheel(int wheelPos) {
            int max = 255;
            int one_third = 85;
            int two_thirds = 170;
            int wheel_pos = max - wheelPos;
            if (wheel_pos < one_third) {
                return LedColor.createColorRGB(max - wheel_pos * 3, 0, wheel_pos * 3);
            }
            if (wheel_pos < two_thirds) {
                return LedColor.createColorRGB(0, (wheel_pos -= one_third) * 3, max - wheel_pos * 3);
            }
            return LedColor.createColorRGB((wheel_pos -= two_thirds) * 3, max - wheel_pos * 3, 0);
        }

        public static int scaleColorToBrightness(int color, double brightness) {
            color = LedColor.setRedComponent(color, (int)((double)LedColor.getRedComponent(color) * brightness));
            color = LedColor.setGreenComponent(color, (int)((double)LedColor.getGreenComponent(color) * brightness));
            color = LedColor.setBlueComponent(color, (int)((double)LedColor.getBlueComponent(color) * brightness));
            return color;
        }

        public static int createColorRGB(float red, float green, float blue) {
            return LedColor.createColorRGB(Math.round(255.0f * red), Math.round(255.0f * green), Math.round(255.0f * blue));
        }

        public static int createColorRGB(int red, int green, int blue) {
            LedColor.validateColorComponent("Red", red);
            LedColor.validateColorComponent("Green", green);
            LedColor.validateColorComponent("Blue", blue);
            return red << 16 | green << 8 | blue;
        }

        public static int createColorHSL(float hue, float saturation, float luminance) {
            if (saturation < 0.0f) {
                saturation = 0.0f;
            }
            if (saturation > 1.0f) {
                saturation = 1.0f;
            }
            if (luminance < 0.0f || luminance > 1.0f) {
                String message = "Color parameter outside of expected range - Luminance";
                throw new IllegalArgumentException(message);
            }
            hue %= 360.0f;
            float q = 0.0f;
            q = (double)luminance < 0.5 ? luminance * (1.0f + saturation) : luminance + saturation - saturation * luminance;
            float p = 2.0f * luminance - q;
            float r = Math.max(0.0f, LedColor.HueToRGB(p, q, (hue /= 360.0f) + 0.33333334f));
            float g2 = Math.max(0.0f, LedColor.HueToRGB(p, q, hue));
            float b = Math.max(0.0f, LedColor.HueToRGB(p, q, hue - 0.33333334f));
            r = Math.min(r, 1.0f);
            g2 = Math.min(g2, 1.0f);
            b = Math.min(b, 1.0f);
            return LedColor.createColorRGB(r, g2, b);
        }

        private static float HueToRGB(float p, float q, float h2) {
            if (h2 < 0.0f) {
                h2 += 1.0f;
            }
            if (h2 > 1.0f) {
                h2 -= 1.0f;
            }
            if (6.0f * h2 < 1.0f) {
                return p + (q - p) * 6.0f * h2;
            }
            if (2.0f * h2 < 1.0f) {
                return q;
            }
            if (3.0f * h2 < 2.0f) {
                return p + (q - p) * 6.0f * (0.6666667f - h2);
            }
            return p;
        }

        public static int getRedComponent(int color) {
            return (color & 0xFF0000) >> 16;
        }

        public static int setRedComponent(int color, int red) {
            LedColor.validateColorComponent("Red", red);
            int new_Color = color & 0xFFFF;
            return new_Color |= red << 16;
        }

        public static int getGreenComponent(int color) {
            return (color & 0xFF00) >> 8;
        }

        public static int setGreenComponent(int color, int green) {
            LedColor.validateColorComponent("Green", green);
            int new_Color = color & 0xFF00FF;
            return new_Color |= green << 8;
        }

        public static int getBlueComponent(int color) {
            return color & 0xFF;
        }

        public static int setBlueComponent(int color, int blue) {
            LedColor.validateColorComponent("Blue", blue);
            int new_Color = color & 0xFFFF00;
            return new_Color |= blue;
        }

        private static void validateColorComponent(String color, int value) {
            if (value < 0 || value >= 256) {
                throw new IllegalArgumentException("Illegal Color value (" + value + ") for '" + color + "' - must be 0..255");
            }
        }
    }
}

