/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.base.PIN;
import com.pi4j.catalog.components.base.PwmActuator;
import com.pi4j.context.Context;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmConfigBuilder;
import com.pi4j.io.pwm.PwmType;
import java.time.Duration;

public class ServoMotor
extends PwmActuator {
    protected static final int DEFAULT_FREQUENCY = 50;
    protected static final float DEFAULT_MIN_ANGLE = -90.0f;
    protected static final float DEFAULT_MAX_ANGLE = 90.0f;
    protected static final float DEFAULT_MIN_DUTY_CYCLE = 2.0f;
    protected static final float DEFAULT_MAX_DUTY_CYCLE = 12.0f;
    private final float minAngle;
    private final float maxAngle;
    private final float minDutyCycle;
    private final float maxDutyCycle;
    private float minRange = 0.0f;
    private float maxRange = 1.0f;

    public ServoMotor(Context pi4j, PIN address) {
        this(pi4j, address, -90.0f, 90.0f, 2.0f, 12.0f);
    }

    public ServoMotor(Context pi4j, PIN address, float minAngle, float maxAngle, float minDutyCycle, float maxDutyCycle) {
        this(pi4j, address, 50, minAngle, maxAngle, minDutyCycle, maxDutyCycle);
    }

    public ServoMotor(Context pi4j, PIN address, int frequency, float minAngle, float maxAngle, float minDutyCycle, float maxDutyCycle) {
        super(pi4j, (PwmConfig)((PwmConfigBuilder)((PwmConfigBuilder)((PwmConfigBuilder)Pwm.newConfigBuilder(pi4j).id("BCM-" + String.valueOf((Object)address))).name("Servo Motor " + String.valueOf((Object)address))).address(address.getPin())).pwmType(PwmType.HARDWARE).frequency(frequency).initial(0).shutdown(0).build());
        this.minAngle = minAngle;
        this.maxAngle = maxAngle;
        this.minDutyCycle = minDutyCycle;
        this.maxDutyCycle = maxDutyCycle;
    }

    @Override
    public void reset() {
        this.setAngle(0.0f);
        this.delay(Duration.ofSeconds(1L));
        super.reset();
    }

    public void setAngle(float angle) {
        this.pwm.on(Float.valueOf(this.mapAngleToDutyCycle(angle)));
    }

    public void setPercent(float percent) {
        this.moveOnRange(percent, 0.0f, 100.0f);
    }

    public void moveOnRange(float value) {
        this.moveOnRange(value, this.minRange, this.maxRange);
    }

    public void moveOnRange(float value, float minValue, float maxValue) {
        this.pwm.on(Float.valueOf(this.mapToDutyCycle(value, minValue, maxValue)));
    }

    public void setRange(float minValue, float maxValue) {
        this.minRange = minValue;
        this.maxRange = maxValue;
    }

    public float getMinAngle() {
        return this.minAngle;
    }

    public float getMaxAngle() {
        return this.maxAngle;
    }

    private float mapAngleToDutyCycle(float angle) {
        return this.mapToDutyCycle(angle, this.minAngle, this.maxAngle);
    }

    private float mapToDutyCycle(float input, float inputStart, float inputEnd) {
        return this.mapRange(input, inputStart, inputEnd, this.minDutyCycle, this.maxDutyCycle);
    }

    private float mapRange(float input, float inputStart, float inputEnd, float outputStart, float outputEnd) {
        float tmp;
        if (inputStart > inputEnd) {
            tmp = inputEnd;
            inputEnd = inputStart;
            inputStart = tmp;
        }
        if (outputStart > outputEnd) {
            tmp = outputEnd;
            outputEnd = outputStart;
            outputStart = tmp;
        }
        float clampedInput = Math.min(inputEnd, Math.max(inputStart, input));
        return outputEnd - (outputEnd - outputStart) / (inputEnd - inputStart) * (clampedInput - inputStart);
    }
}

