/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components.base;

import com.pi4j.catalog.components.base.Component;
import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import com.pi4j.plugin.mock.provider.i2c.MockI2C;
import java.time.Duration;

public abstract class I2CDevice
extends Component {
    protected static final int DEFAULT_BUS = 1;
    private final I2C i2c;

    protected I2CDevice(Context pi4j, int device, String name) {
        this.i2c = pi4j.create((I2CConfig)((I2CConfigBuilder)((I2CConfigBuilder)I2C.newConfigBuilder(pi4j).id("I2C-1@" + device)).name(name + "@" + device)).bus(1).device(device).build());
        this.init(this.i2c);
        this.logDebug("I2C device %s initialized", name);
    }

    protected void sendCommand(byte cmd) {
        this.i2c.write(cmd);
        this.delay(Duration.ofNanos(100000L));
    }

    protected int readRegister(int register) {
        return this.i2c.readRegisterWord(register);
    }

    protected void writeRegister(int register, int config) {
        this.i2c.writeRegisterWord(register, config);
    }

    protected void write(byte data) {
        this.i2c.write(data);
    }

    protected void sendCommand(byte command, byte data) {
        this.sendCommand((byte)(command | data));
    }

    protected abstract void init(I2C var1);

    public MockI2C mock() {
        return this.asMock(MockI2C.class, this.i2c);
    }
}

