/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.config.impl;

import com.pi4j.config.Config;
import com.pi4j.config.ConfigBuilder;
import com.pi4j.context.Context;
import com.pi4j.util.PropertiesUtil;
import com.pi4j.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class ConfigBuilderBase<BUILDER_TYPE extends ConfigBuilder, CONFIG_TYPE extends Config>
implements ConfigBuilder<BUILDER_TYPE, CONFIG_TYPE> {
    protected final ConcurrentHashMap<String, String> properties = new ConcurrentHashMap();
    protected Boolean inheritProperties = true;
    protected Context context = null;

    protected ConfigBuilderBase(Context context) {
        this.context = context;
    }

    @Override
    public BUILDER_TYPE id(String id) {
        this.properties.put("id", id);
        return (BUILDER_TYPE)this;
    }

    @Override
    public String id() {
        return this.properties.get("id");
    }

    @Override
    public BUILDER_TYPE name(String name) {
        this.properties.put("name", name);
        return (BUILDER_TYPE)this;
    }

    @Override
    public BUILDER_TYPE description(String description) {
        this.properties.put("description", description);
        return (BUILDER_TYPE)this;
    }

    @Override
    public BUILDER_TYPE inheritProperties(Boolean allow) {
        this.inheritProperties = allow;
        return (BUILDER_TYPE)this;
    }

    @Override
    public BUILDER_TYPE load(Map<String, String> properties) {
        this.properties.putAll(properties);
        return (BUILDER_TYPE)this;
    }

    @Override
    public BUILDER_TYPE load(Map<String, String> properties, String prefixFilter) {
        if (StringUtil.isNullOrEmpty(prefixFilter)) {
            return (BUILDER_TYPE)this.load((Map)properties);
        }
        Object prefix = prefixFilter.endsWith(".") ? prefixFilter : prefixFilter + ".";
        properties.keySet().stream().filter(arg_0 -> ConfigBuilderBase.lambda$load$0((String)prefix, arg_0)).forEach(arg_0 -> this.lambda$load$1((String)prefix, properties, arg_0));
        return (BUILDER_TYPE)this;
    }

    @Override
    public BUILDER_TYPE load(Properties properties) {
        return (BUILDER_TYPE)this.load(properties, (String)null);
    }

    @Override
    public BUILDER_TYPE load(Properties properties, String prefixFilter) {
        Map<String, String> entries = properties.keySet().stream().collect(Collectors.toMap(k -> k.toString(), key -> properties.get(key).toString()));
        return (BUILDER_TYPE)this.load((Map)entries, prefixFilter);
    }

    @Override
    public BUILDER_TYPE load(InputStream stream) throws IOException {
        return (BUILDER_TYPE)this.load(stream, null);
    }

    @Override
    public BUILDER_TYPE load(InputStream stream, String prefixFilter) throws IOException {
        Properties prop = new Properties();
        prop.load(stream);
        return (BUILDER_TYPE)this.load(prop, prefixFilter);
    }

    @Override
    public BUILDER_TYPE load(Reader reader) throws IOException {
        return (BUILDER_TYPE)this.load(reader, null);
    }

    @Override
    public BUILDER_TYPE load(Reader reader, String prefixFilter) throws IOException {
        Properties prop = new Properties();
        prop.load(reader);
        return (BUILDER_TYPE)this.load(prop, prefixFilter);
    }

    @Override
    public BUILDER_TYPE load(File file) throws IOException {
        return (BUILDER_TYPE)this.load(file, null);
    }

    @Override
    public BUILDER_TYPE load(File file, String prefixFilter) throws IOException {
        Properties prop = new Properties();
        prop.load(new FileInputStream(file));
        return (BUILDER_TYPE)this.load(prop, prefixFilter);
    }

    protected Map<String, String> getResolvedProperties() {
        Map<String, String> candidateProperties;
        HashMap<String, String> allProperties = new HashMap<String, String>(this.properties);
        if (this.inheritProperties.booleanValue() && StringUtil.isNotNullOrEmpty(this.id()) && !(candidateProperties = PropertiesUtil.subProperties(this.context.properties().all(), this.id())).isEmpty()) {
            candidateProperties.forEach((key, value) -> {
                if (!allProperties.containsKey(key)) {
                    allProperties.put((String)key, (String)value);
                }
            });
        }
        return Collections.unmodifiableMap(allProperties);
    }

    private /* synthetic */ void lambda$load$1(String prefix, Map properties, String key) {
        this.properties.put(key.substring(prefix.length()), (String)properties.get(key));
    }

    private static /* synthetic */ boolean lambda$load$0(String prefix, String key) {
        return key.startsWith(prefix);
    }
}

