/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.context.impl;

import com.pi4j.boardinfo.model.BoardInfo;
import com.pi4j.boardinfo.util.BoardInfoHelper;
import com.pi4j.context.Context;
import com.pi4j.context.ContextConfig;
import com.pi4j.context.ContextProperties;
import com.pi4j.context.impl.DefaultContextProperties;
import com.pi4j.event.InitializedListener;
import com.pi4j.event.ShutdownListener;
import com.pi4j.exception.LifecycleException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.IO;
import com.pi4j.platform.Platforms;
import com.pi4j.platform.impl.DefaultPlatforms;
import com.pi4j.provider.Providers;
import com.pi4j.provider.impl.DefaultProviders;
import com.pi4j.registry.Registry;
import com.pi4j.registry.impl.DefaultRegistry;
import com.pi4j.runtime.Runtime;
import com.pi4j.runtime.impl.DefaultRuntime;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContext
implements Context {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Runtime runtime = null;
    private ContextConfig config = null;
    private ContextProperties properties = null;
    private Providers providers = null;
    private Platforms platforms = null;
    private Registry registry = null;
    private BoardInfo boardInfo = null;

    public static Context newInstance(ContextConfig config) {
        return new DefaultContext(config);
    }

    private DefaultContext(ContextConfig config) {
        this.logger.trace("new Pi4J runtime context initialized [config={}]", (Object)config);
        if (config == null) {
            throw new LifecycleException("Unable to create new Pi4J runtime context; missing (ContextConfig) config object.");
        }
        this.config = config;
        this.runtime = DefaultRuntime.newInstance(this);
        this.properties = DefaultContextProperties.newInstance(this.runtime.properties());
        this.registry = DefaultRegistry.newInstance(this.runtime.registry());
        this.providers = DefaultProviders.newInstance(this.runtime.providers());
        this.platforms = DefaultPlatforms.newInstance(this.runtime.platforms());
        this.boardInfo = BoardInfoHelper.current();
        this.logger.info("Detected board model: {}", (Object)this.boardInfo.getBoardModel().getLabel());
        this.logger.info("Running on: {}", (Object)this.boardInfo.getOperatingSystem());
        this.logger.info("With Java version: {}", (Object)this.boardInfo.getJavaInfo());
        this.runtime.initialize();
        this.logger.debug("Pi4J runtime context successfully created & initialized.'");
    }

    @Override
    public ContextConfig config() {
        return this.config;
    }

    @Override
    public ContextProperties properties() {
        return this.properties;
    }

    @Override
    public Providers providers() {
        return this.providers;
    }

    @Override
    public Registry registry() {
        return this.registry;
    }

    @Override
    public Platforms platforms() {
        return this.platforms;
    }

    @Override
    public BoardInfo boardInfo() {
        return this.boardInfo;
    }

    @Override
    public Future<?> submitTask(Runnable task) {
        return this.runtime.submitTask(task);
    }

    @Override
    public Context shutdown() throws ShutdownException {
        this.runtime.shutdown();
        return this;
    }

    @Override
    public <T extends IO> T shutdown(String id) {
        return this.runtime.registry().remove(id);
    }

    @Override
    public boolean isShutdown() {
        return this.runtime.isShutdown();
    }

    @Override
    public Future<Context> asyncShutdown() {
        return this.runtime.asyncShutdown();
    }

    @Override
    public Context addListener(ShutdownListener ... listener) {
        this.runtime.addListener(listener);
        return this;
    }

    @Override
    public Context removeListener(ShutdownListener ... listener) {
        this.runtime.removeListener(listener);
        return this;
    }

    @Override
    public Context removeAllShutdownListeners() {
        this.runtime.removeAllShutdownListeners();
        return this;
    }

    @Override
    public Context removeAllInitializedListeners() {
        this.runtime.removeAllInitializedListeners();
        return this;
    }

    @Override
    public Context addListener(InitializedListener ... listener) {
        this.runtime.addListener(listener);
        return this;
    }

    @Override
    public Context removeListener(InitializedListener ... listener) {
        this.runtime.removeListener(listener);
        return this;
    }
}

