/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.event;

import com.pi4j.event.EventDelegate;
import com.pi4j.event.Listener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager<SOURCE_TYPE, LISTENER_TYPE extends Listener, EVENT_TYPE> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SOURCE_TYPE source;
    private final Set<LISTENER_TYPE> listeners = new CopyOnWriteArraySet<LISTENER_TYPE>();
    private final EventDelegate<LISTENER_TYPE, EVENT_TYPE> delegate;

    public EventManager(SOURCE_TYPE source, EventDelegate<LISTENER_TYPE, EVENT_TYPE> delegate) {
        this.source = source;
        this.delegate = delegate;
    }

    public SOURCE_TYPE add(LISTENER_TYPE ... listener) {
        this.listeners.addAll(List.of(listener));
        return this.source;
    }

    public SOURCE_TYPE remove(LISTENER_TYPE ... listener) {
        this.listeners.removeAll(List.of(listener));
        return this.source;
    }

    public SOURCE_TYPE clear() {
        this.listeners.clear();
        return this.source;
    }

    public SOURCE_TYPE dispatch(EVENT_TYPE event) {
        this.listeners.forEach(listener -> {
            try {
                this.delegate.dispatch((Listener)listener, event);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        });
        return this.source;
    }

    public SOURCE_TYPE dispatch(EVENT_TYPE event, EventDelegate<LISTENER_TYPE, EVENT_TYPE> delegate) {
        this.listeners.forEach(listener -> {
            try {
                delegate.dispatch(listener, event);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        });
        return this.source;
    }
}

