/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io;

import com.pi4j.io.exception.IOReadException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public interface IODataReader
extends Readable {
    public int read();

    public int read(byte[] var1, int var2, int var3);

    default public int read(byte[] buffer, int length) {
        return this.read(buffer, 0, length);
    }

    default public int read(byte[] buffer) {
        return this.read(buffer, buffer.length);
    }

    default public int read(ByteBuffer buffer, int offset, int length) {
        byte[] temp;
        int actualLength;
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        if ((actualLength = this.read(temp = new byte[length], 0, length)) < 0) {
            return actualLength;
        }
        if (actualLength < length) {
            length = actualLength;
        }
        buffer.position(offset);
        buffer.put(temp, 0, length);
        return length;
    }

    default public int read(ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.read(buffer, buffer.position(), length);
    }

    default public int read(ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.read(buffer, buffer.position(), buffer.remaining());
    }

    default public int read(Charset charset, char[] buffer, int offset, int length) {
        int maxBytes = (int)charset.newDecoder().maxCharsPerByte() * length;
        byte[] rx = new byte[maxBytes];
        int actualLength = this.read(rx, maxBytes);
        if (actualLength < 0) {
            return actualLength;
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(rx));
        if (actualLength < length) {
            length = actualLength;
        }
        if (length > buffer.length - offset) {
            length = buffer.length - offset;
        }
        cb.get(buffer, offset, length);
        return actualLength;
    }

    default public int read(Charset charset, char[] buffer, int length) {
        return this.read(buffer, 0, length);
    }

    default public int read(Charset charset, char[] buffer) {
        return this.read(buffer, buffer.length);
    }

    default public int read(char[] buffer, int offset, int length) {
        return this.read(StandardCharsets.US_ASCII, buffer, offset, length);
    }

    default public int read(char[] buffer, int length) {
        return this.read(StandardCharsets.US_ASCII, buffer, length);
    }

    default public int read(char[] buffer) {
        return this.read(StandardCharsets.US_ASCII, buffer, buffer.length);
    }

    default public int read(Charset charset, CharBuffer buffer, int offset, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Invalid read request; length must be greater than zero.");
        }
        int maxBytes = (int)charset.newDecoder().maxCharsPerByte() * length;
        byte[] rx = new byte[maxBytes];
        int actualLength = this.read(rx, maxBytes);
        if (actualLength < 0) {
            return actualLength;
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(rx));
        if (actualLength < length) {
            length = actualLength;
        }
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        buffer.position(offset);
        buffer.put(cb.array(), 0, length);
        return actualLength;
    }

    default public int read(Charset charset, CharBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.read(buffer, buffer.position(), length);
    }

    default public int read(Charset charset, CharBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.rewind();
        }
        return this.read(buffer, buffer.position(), buffer.remaining());
    }

    default public int read(CharBuffer buffer, int offset, int length) {
        return this.read(StandardCharsets.US_ASCII, buffer, offset, length);
    }

    default public int read(CharBuffer buffer, int length) {
        return this.read(StandardCharsets.US_ASCII, buffer, length);
    }

    @Override
    default public int read(CharBuffer buffer) {
        return this.read(StandardCharsets.US_ASCII, buffer);
    }

    default public byte readByte() {
        int actual = this.read();
        if (actual < 0) {
            throw new IOReadException("I2C READ ERROR; " + actual);
        }
        return (byte)actual;
    }

    default public byte[] readNBytes(int offset, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length <= 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (length < offset) {
            throw new IllegalArgumentException("length < offset");
        }
        int bufferSize = length - offset;
        byte[] temp = new byte[bufferSize];
        int actual = this.read(temp, offset, length);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        return Arrays.copyOf(temp, actual);
    }

    default public byte[] readNBytes(int length) {
        return this.readNBytes(0, length);
    }

    default public ByteBuffer readByteBuffer(int offset, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length <= 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (length < offset) {
            throw new IllegalArgumentException("length < offset");
        }
        int bufferSize = length - offset;
        byte[] temp = new byte[bufferSize];
        int actual = this.read(temp, offset, length);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        return ByteBuffer.wrap(temp, 0, actual);
    }

    default public ByteBuffer readByteBuffer(int length) {
        return this.readByteBuffer(0, length);
    }

    default public char[] readCharArray(Charset charset, int offset, int numberOfBytes) {
        byte[] temp = new byte[numberOfBytes];
        int actual = this.read(temp, offset, numberOfBytes);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(temp, 0, actual));
        return cb.array();
    }

    default public char[] readCharArray(Charset charset, int numberOfBytes) {
        return this.readCharArray(charset, 0, numberOfBytes);
    }

    default public char[] readCharArray(int offset, int numberOfBytes) {
        return this.readCharArray(StandardCharsets.US_ASCII, offset, numberOfBytes);
    }

    default public char[] readCharArray(int numberOfBytes) {
        return this.readCharArray(0, numberOfBytes);
    }

    default public CharBuffer readCharBuffer(Charset charset, int offset, int numberOfBytes) {
        byte[] temp = new byte[numberOfBytes];
        int actual = this.read(temp, offset, numberOfBytes);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        CharBuffer cb = charset.decode(ByteBuffer.wrap(temp, 0, actual));
        return cb.flip();
    }

    default public CharBuffer readCharBuffer(Charset charset, int numberOfBytes) {
        return this.readCharBuffer(charset, 0, numberOfBytes);
    }

    default public CharBuffer readCharBuffer(int offset, int numberOfBytes) {
        return this.readCharBuffer(StandardCharsets.US_ASCII, offset, numberOfBytes);
    }

    default public CharBuffer readCharBuffer(int numberOfBytes) {
        return this.readCharBuffer(0, numberOfBytes);
    }

    default public String readString(Charset charset, int offset, int numberOfBytes) {
        byte[] temp = new byte[numberOfBytes];
        int actual = this.read(temp, offset, numberOfBytes);
        if (actual < 0) {
            throw new IOReadException(actual);
        }
        return new String(temp, 0, actual, charset);
    }

    default public String readString(Charset charset, int numberOfBytes) {
        return this.readString(charset, 0, numberOfBytes);
    }

    default public String readString(int offset, int numberOfBytes) {
        return this.readString(StandardCharsets.US_ASCII, offset, numberOfBytes);
    }

    default public String readString(int numberOfBytes) {
        return this.readString(0, numberOfBytes);
    }

    default public InputStream getInputStream() {
        final IODataReader t2 = this;
        return new InputStream(this){
            final /* synthetic */ IODataReader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int read() {
                return t2.read();
            }

            @Override
            public int read(byte[] b, int off, int len) {
                Objects.checkFromIndexSize(off, len, b.length);
                return t2.read(b, off, len);
            }

            @Override
            public int readNBytes(byte[] b, int off, int len) {
                Objects.checkFromIndexSize(off, len, b.length);
                return t2.read(b, off, len);
            }

            @Override
            public byte[] readNBytes(int len) {
                return t2.readNBytes(len);
            }
        };
    }

    default public InputStream in() {
        return this.getInputStream();
    }
}

