/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io;

import com.pi4j.exception.Pi4JException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public interface IODataWriter {
    public int write(byte var1);

    default public int write(int b) {
        return this.write((byte)b);
    }

    public int write(byte[] var1, int var2, int var3);

    default public int write(byte[] data, int length) {
        return this.write(data, 0, length);
    }

    default public int write(byte ... data) {
        return this.write(data, 0, data.length);
    }

    default public int write(byte[] ... data) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (byte[] ba : data) {
                os.write(ba);
            }
            return this.write(os.toByteArray());
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public int write(Collection<byte[]> data) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (byte[] ba : data) {
                os.write(ba);
            }
            return this.write(os.toByteArray());
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public int write(ByteBuffer buffer, int offset, int length) {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        return this.write(buffer.array(), offset, length);
    }

    default public int write(ByteBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.write(buffer, buffer.position(), length);
    }

    default public int write(ByteBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        return this.write(buffer, buffer.position(), buffer.remaining());
    }

    default public int write(ByteBuffer ... buffer) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (ByteBuffer bb : buffer) {
                if (bb.position() == bb.limit()) {
                    bb.flip();
                }
                os.write(bb.array());
            }
            return this.write(os.toByteArray());
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public int write(InputStream stream) {
        try {
            return this.write(stream.readAllBytes());
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public int write(InputStream stream, int length) {
        try {
            return this.write(stream.readNBytes(length));
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public int write(InputStream ... stream) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (InputStream is : stream) {
                os.write(is.readAllBytes());
            }
            return this.write(os.toByteArray());
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public int write(Charset charset, CharSequence data) {
        return this.write(data.toString().getBytes(charset));
    }

    default public int write(Charset charset, CharSequence ... data) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence d : data) {
            builder.append(d);
        }
        return this.write(charset, (CharSequence)builder);
    }

    default public int write(Charset charset, Collection<CharSequence> ... data) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (Collection<CharSequence> csc : data) {
                for (CharSequence cs : csc) {
                    os.write(cs.toString().getBytes(charset));
                }
            }
            return this.write(os.toByteArray());
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public int write(CharSequence data) {
        return this.write(StandardCharsets.US_ASCII, data);
    }

    default public int write(CharSequence ... data) {
        return this.write(StandardCharsets.US_ASCII, data);
    }

    default public int write(Collection<CharSequence> ... data) {
        return this.write(StandardCharsets.US_ASCII, data);
    }

    default public int write(char[] data, int offset, int length) {
        return this.write(StandardCharsets.US_ASCII, data, offset, length);
    }

    default public int write(char[] data, int length) {
        return this.write(StandardCharsets.US_ASCII, data, length);
    }

    default public int write(char ... data) {
        return this.write(StandardCharsets.US_ASCII, data);
    }

    default public int write(Charset charset, char[] data, int offset, int length) {
        ByteBuffer bb = charset.encode(CharBuffer.wrap(data, offset, length));
        return this.write(bb.array());
    }

    default public int write(Charset charset, char[] data, int length) {
        ByteBuffer bb = charset.encode(CharBuffer.wrap(data, 0, length));
        return this.write(bb.array());
    }

    default public int write(Charset charset, char ... data) {
        ByteBuffer bb = charset.encode(CharBuffer.wrap(data));
        return this.write(bb.array());
    }

    default public int write(Charset charset, Collection<char[]> data) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (char[] ca : data) {
                ByteBuffer bb = charset.encode(CharBuffer.wrap(ca));
                os.write(bb.array());
            }
            return this.write(os.toByteArray());
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public int write(CharBuffer buffer, int offset, int length) {
        return this.write(StandardCharsets.US_ASCII, buffer, offset, length);
    }

    default public int write(CharBuffer buffer, int length) throws IOException {
        return this.write(StandardCharsets.US_ASCII, buffer, length);
    }

    default public int write(CharBuffer buffer) {
        return this.write(StandardCharsets.US_ASCII, buffer);
    }

    default public int write(CharBuffer ... buffer) {
        return this.write(StandardCharsets.US_ASCII, buffer);
    }

    default public int write(Charset charset, CharBuffer buffer, int offset, int length) {
        if (length > buffer.capacity() - offset) {
            length = buffer.capacity() - offset;
        }
        ByteBuffer bb = charset.encode(CharBuffer.wrap(buffer.array(), offset, length));
        return this.write(bb.array());
    }

    default public int write(Charset charset, CharBuffer buffer, int length) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        if (length > buffer.remaining()) {
            length = buffer.remaining();
        }
        return this.write(charset, buffer, buffer.position(), length);
    }

    default public int write(Charset charset, CharBuffer buffer) {
        if (buffer.position() == buffer.limit()) {
            buffer.flip();
        }
        return this.write(charset, buffer, buffer.position(), buffer.remaining());
    }

    default public int write(Charset charset, CharBuffer ... buffer) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (CharBuffer cb : buffer) {
                if (cb.position() == cb.limit()) {
                    cb.flip();
                }
                ByteBuffer bb = charset.encode(CharBuffer.wrap(cb.array(), cb.position(), cb.remaining()));
                os.write(bb.array());
            }
            return this.write(os.toByteArray());
        }
        catch (IOException e) {
            throw new Pi4JException(e);
        }
    }

    default public OutputStream getOutputStream() {
        final IODataWriter t2 = this;
        return new OutputStream(this){
            final /* synthetic */ IODataWriter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void write(int b) {
                t2.write((byte)b);
            }

            @Override
            public void write(byte[] b) {
                t2.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) {
                this.write(b, off, len);
            }
        };
    }

    default public OutputStream out() {
        return this.getOutputStream();
    }
}

